/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.widgets.ui.actionsets;

import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.decoration.relation.RelationDecorator;
import com.centreon.studio.client.model.decoration.repository.RepositoryDecorator;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.node.NodeFactories;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.utils.SequenceUtils;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import com.centreon.studio.map.client.elements.widgets.ui.actionsets.ClientCreatedRelations;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;

public class ConvertNodeActionExecutor {
    private final TypeDescriptor typeToReplace;
    private final TypeDescriptor newType;
    protected final RepositoryDecorator repositoryDecorator;
    private final Collection<INodeRelation> relationsToRepalce;

    public ConvertNodeActionExecutor(TypeDescriptor typeToReplace, TypeDescriptor newType, Collection<INodeRelation> relationsToReplace, RepositoryDecorator repositoryDecorator) {
        this.typeToReplace = typeToReplace;
        this.newType = newType;
        this.repositoryDecorator = repositoryDecorator;
        this.relationsToRepalce = relationsToReplace;
        for (INodeRelation relationToReplace : relationsToReplace) {
            Assert.isTrue((boolean)(relationToReplace instanceof RelationDecorator));
        }
    }

    public ClientCreatedRelations convertElements() {
        ArrayList<INodeRelation> createdRelations = new ArrayList<INodeRelation>(this.relationsToRepalce.size());
        for (INodeRelation relation : this.relationsToRepalce) {
            if (!this.typeToReplace.equals((Object)relation.getTarget().getType())) continue;
            INodeRelation newRelation = this.convertElement(relation);
            createdRelations.add(newRelation);
        }
        ClientCreatedRelations clientCreatedRelations = new ClientCreatedRelations(this.repositoryDecorator, createdRelations);
        for (INodeRelation createdRelation : createdRelations) {
            INode source = createdRelation.getSource();
            INode decoratedSource = INodeUtils.findNode((INode)this.repositoryDecorator, (TypeDescriptor)source.getType(), (Long)source.getId(), (PropertyValue[])new PropertyValue[0]);
            decoratedSource.addRelation(createdRelation);
        }
        return clientCreatedRelations;
    }

    private INodeRelation convertElement(INodeRelation relation) {
        INodeRelation newRelation = this.createNewRelation(relation);
        relation.getSource().removeRelation(relation);
        return newRelation;
    }

    private INodeRelation createNewRelation(INodeRelation relation) {
        INode target = relation.getTarget();
        ArrayList<PropertyValue> nodeProperties = new ArrayList<PropertyValue>();
        nodeProperties.add(new PropertyValue(ElementPropertyDescriptors.RESOURCE_ID, (Object)((Long)target.getProperty(ElementPropertyDescriptors.RESOURCE_ID))));
        nodeProperties.add(new PropertyValue(ElementPropertyDescriptors.RESOURCE_TYPE, (Object)((TypeDescriptor)target.getProperty(ElementPropertyDescriptors.RESOURCE_TYPE))));
        Long newNodeId = SequenceUtils.next();
        nodeProperties.add(new PropertyValue(PropertyDescriptors.PREVIOUS_ID, (Object)newNodeId));
        INode newNode = NodeFactories.INSTANCE.create(this.newType, newNodeId, nodeProperties, relation.getRepository());
        ArrayList<PropertyValue> relationProperties = new ArrayList<PropertyValue>();
        relationProperties.add(new PropertyValue(PropertyDescriptors.POSITION, (Object)((Pos)relation.getProperty(PropertyDescriptors.POSITION))));
        Long newRelationId = SequenceUtils.next();
        return NodeRelationFactories.INSTANCE.create(ElementTypes.RELATION_HIERARCHY, newRelationId, relation.getSource(), newNode, relationProperties);
    }
}

