/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.widgets.ui.gef.parts;

import com.centreon.studio.client.chart.LinesChart;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.ListOfMetricLine;
import com.centreon.studio.client.model.StudioColor;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.map.client.elements.GraphUtils;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.elements.widgets.model.WidgetPropertyDescriptors;
import com.centreon.studio.map.client.elements.widgets.ui.gef.figures.LinesChartFigure;
import com.centreon.studio.map.client.elements.widgets.ui.gef.parts.AWidgetGraphicalEditPart;
import com.centreon.studio.map.client.status.GraphWebService;
import com.centreon.studio.map.client.status.model.GraphData;
import com.centreon.studio.map.client.status.model.GraphPropertyDescriptors;
import com.centreon.studio.map.client.status.model.MetricData;
import com.centreon.studio.map.client.status.model.Status;
import com.centreon.studio.map.client.status.model.StatusPropertyDescriptors;
import com.centreon.studio.map.client.status.model.StatusTypes;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class LinesChartWidgetGraphicalEditPart
extends AWidgetGraphicalEditPart {
    private static final Collection<PropertyDescriptor<?>> PROPERTIES_FOR_REFRESH = new ArrayList(5);
    private boolean needRefreshValues = true;
    private GraphWebService service;

    static {
        PROPERTIES_FOR_REFRESH.add(StatusPropertyDescriptors.CHECK_LAST);
        PROPERTIES_FOR_REFRESH.add(GraphPropertyDescriptors.CHART_DATE_FORMAT);
        PROPERTIES_FOR_REFRESH.add(GraphPropertyDescriptors.LINE_CHART_PERIOD);
        PROPERTIES_FOR_REFRESH.add(GraphPropertyDescriptors.LINE_CHART_NB_POINTS);
        PROPERTIES_FOR_REFRESH.add(GraphPropertyDescriptors.CHART_DISPLAY_THRESHOLD);
    }

    private static void addLine(GraphData graphData, PropertyDescriptor<Double> property, Status status, INode node) {
        for (INodeRelation relation : node.getRelations(new TypeDescriptor[]{StatusTypes.METRIC})) {
            double value = (Double)relation.getTarget().getProperty(property);
            if (Double.NEGATIVE_INFINITY == value || Double.POSITIVE_INFINITY == value) continue;
            String unit = (String)relation.getTarget().getProperty(StatusPropertyDescriptors.METRIC_UNIT);
            StudioColor studioColor = (StudioColor)status.getProperty(PropertyDescriptors.COLOR);
            String hex = studioColor.toHexadecimal();
            MetricData metricData = MetricData.createLinearMetricData((String)property.label, (String)unit, (String)hex, (boolean)false, (Double)value, (int)graphData.getTimes().size());
            metricData.setThreshold(true);
            graphData.addMetric(metricData);
        }
    }

    public LinesChartWidgetGraphicalEditPart(INodeRelation relation) {
        super(relation);
    }

    protected IFigure createFigure() {
        return new LinesChartFigure();
    }

    public LinesChartFigure getFigure() {
        return (LinesChartFigure)super.getFigure();
    }

    private void loadGraphWebService() {
        IEclipseContext context = (IEclipseContext)this.getViewer().getProperty(IEclipseContext.class.getSimpleName());
        this.service = (GraphWebService)ContextInjectionFactory.make(GraphWebService.class, (IEclipseContext)context);
    }

    public void propertiesChanged(IObject object, Collection<PropertyValue> propertyValues) {
        for (PropertyValue propertyValue : propertyValues) {
            if (!PROPERTIES_FOR_REFRESH.contains(propertyValue.getProperty())) continue;
            this.needRefreshValues = true;
            break;
        }
        super.propertiesChanged(object, propertyValues);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        INode target = this.getModel().getTarget();
        Integer alpha = (Boolean)target.getProperty(PropertyDescriptors.OPAQUE) == false ? (Integer)target.getProperty(PropertyDescriptors.ALPHA) : Integer.valueOf(255);
        LinesChartFigure figure = this.getFigure();
        LinesChart chart = figure.getChart();
        if (this.needRefreshValues) {
            GraphData graphData;
            this.needRefreshValues = false;
            long serviceId = (Long)target.getProperty(ElementPropertyDescriptors.RESOURCE_ID);
            Integer period = (Integer)target.getProperty(GraphPropertyDescriptors.LINE_CHART_PERIOD) * 3600;
            Integer points = (Integer)target.getProperty(GraphPropertyDescriptors.LINE_CHART_NB_POINTS);
            if (this.service == null) {
                this.loadGraphWebService();
            }
            if ((graphData = this.service.getGraph(serviceId, (long)period.intValue(), points.intValue())) == null) {
                return;
            }
            if (((Boolean)target.getProperty(GraphPropertyDescriptors.CHART_DISPLAY_THRESHOLD)).booleanValue()) {
                LinesChartWidgetGraphicalEditPart.addLine(graphData, (PropertyDescriptor<Double>)StatusPropertyDescriptors.METRIC_CRIT, Status.CRITICAL, target);
                LinesChartWidgetGraphicalEditPart.addLine(graphData, (PropertyDescriptor<Double>)StatusPropertyDescriptors.METRIC_WARN, Status.WARNING, target);
                LinesChartWidgetGraphicalEditPart.addLine(graphData, (PropertyDescriptor<Double>)StatusPropertyDescriptors.METRIC_MIN, Status.UNKNOWN, target);
                LinesChartWidgetGraphicalEditPart.addLine(graphData, (PropertyDescriptor<Double>)StatusPropertyDescriptors.METRIC_MAX, Status.UNKNOWN, target);
            }
            chart.setShowThreshold(((Boolean)target.getProperty(GraphPropertyDescriptors.CHART_DISPLAY_THRESHOLD)).booleanValue());
            chart.setLines(GraphUtils.getLinesFromGraph((GraphData)graphData));
            chart.setDates(graphData.getTimesInMilliAsArray());
        }
        figure.getChart().setAlpha(alpha.intValue());
        figure.getChart().setStack(((Boolean)target.getProperty(GraphPropertyDescriptors.CHART_STACK)).booleanValue());
        figure.getChart().setShowGrid(((Boolean)target.getProperty(GraphPropertyDescriptors.CHART_SHOW_GRID)).booleanValue());
        figure.getChart().setFill(((Boolean)target.getProperty(GraphPropertyDescriptors.CHART_FILL_LINES)).booleanValue());
        figure.getChart().setMarkerSize(((Integer)target.getProperty(GraphPropertyDescriptors.CHART_MARKER_SIZE)).intValue());
        figure.getChart().setMarkerStyle((String)target.getProperty(GraphPropertyDescriptors.CHART_MARKER_STYLE));
        figure.getChart().getLegend().setVisible(((Boolean)target.getProperty(GraphPropertyDescriptors.CHART_DISPLAY_LEGEND)).booleanValue());
        figure.getChart().refreshLines((ListOfMetricLine)target.getProperty(WidgetPropertyDescriptors.LINE_CHART_LINES));
        SWTUtils.getDisplay().syncExec(figure::regenerateChart);
    }
}

