/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.widgets.ui.gef.parts;

import com.centreon.studio.client.chart.PieChart;
import com.centreon.studio.client.chart.PieData;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.StudioColor;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeRelationListener;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.IPropertiesListener;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.utils.CollectionsUtils;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import com.centreon.studio.map.client.elements.widgets.ui.gef.figures.PieChartFigure;
import com.centreon.studio.map.client.elements.widgets.ui.gef.parts.AWidgetGraphicalEditPart;
import com.centreon.studio.map.client.status.model.GraphPropertyDescriptors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.draw2d.IFigure;

public class PieChartWidgetGraphicalEditPart
extends AWidgetGraphicalEditPart
implements Observer {
    private static final Collection<PropertyDescriptor<?>> GRAPHICAL_PROPERTIES = new ArrayList();
    private static final int GLOBAL_REFRESH_DELAY = 3000;
    private static final PieChartRefresher REFRESHER = new PieChartRefresher();

    static {
        GRAPHICAL_PROPERTIES.add(PropertyDescriptors.DIMENSION);
        GRAPHICAL_PROPERTIES.add(PropertyDescriptors.CURRENT_DIMENSION);
        GRAPHICAL_PROPERTIES.add(PropertyDescriptors.POSITION);
        GRAPHICAL_PROPERTIES.add(PropertyDescriptors.CURRENT_POSITION);
    }

    private static List<PieData> getDatas(Map<INode, Double> map, Integer alpha) {
        ArrayList<PieData> datas = new ArrayList<PieData>(map.size());
        for (Map.Entry<INode, Double> type : map.entrySet()) {
            Double count = type.getValue();
            String label = type.getKey().getLabel();
            StudioColor studioColor = (StudioColor)type.getKey().getProperty(PropertyDescriptors.COLOR);
            ColorDefinition definition = ColorDefinitionImpl.create((int)studioColor.getRed(), (int)studioColor.getGreen(), (int)studioColor.getBlue(), (int)alpha);
            datas.add(new PieData(label, count, definition));
        }
        return datas;
    }

    private static Map<INode, Double> status(INode node) {
        Map map = CollectionsUtils.createMap((int)10, (Object)0.0);
        TypeDescriptor resourceType = (TypeDescriptor)node.getProperty(ElementPropertyDescriptors.RESOURCE_TYPE);
        TypeDescriptor elementType = ElementTypes.getElementTypeForResourceType((TypeDescriptor)resourceType);
        TypeDescriptor childrenType = ElementTypes.getChildrenTypeForElementType((TypeDescriptor)elementType);
        for (INodeRelation relation : node.getRelations(new TypeDescriptor[0])) {
            INode targetNode = relation.getTarget();
            Boolean isTargetNodeActive = (Boolean)targetNode.getProperty(PropertyDescriptors.ACTIVE);
            if (targetNode.getType() != childrenType || isTargetNodeActive != null && Boolean.FALSE.equals(isTargetNodeActive)) continue;
            PropertyDescriptor pd = ElementTypes.getStatusTypeForElementType((TypeDescriptor)targetNode.getType());
            INode status = (INode)relation.getTarget().getProperty(pd);
            Double count = (Double)map.get(status) + 1.0;
            map.put(status, count);
        }
        return map;
    }

    public PieChartWidgetGraphicalEditPart(INodeRelation relation) {
        super(relation);
    }

    public void activate() {
        REFRESHER.addObserver(this);
        if (!this.activated) {
            this.activate(this.getModel().getTarget());
        }
        super.activate();
    }

    public void deactivate() {
        REFRESHER.deleteObserver(this);
        if (this.activated) {
            this.deactivate(this.getModel().getTarget());
        }
        super.deactivate();
    }

    public PieChartFigure getFigure() {
        return (PieChartFigure)super.getFigure();
    }

    public void propertiesChanged(IObject object, Collection<PropertyValue> propertyValues) {
        for (PropertyValue p : propertyValues) {
            if (!GRAPHICAL_PROPERTIES.contains(p.getProperty())) continue;
            this.refreshVisuals();
            return;
        }
    }

    public void relationsAdded(INode node, Collection<INodeRelation> relations) {
    }

    public void relationsRemoved(INode node, Collection<INodeRelation> relations) {
    }

    @Override
    public void update(Observable o, Object arg) {
        this.refreshVisuals();
    }

    protected IFigure createFigure() {
        return new PieChartFigure();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        INode widget = this.getModel().getTarget();
        Integer alpha = (Boolean)widget.getProperty(PropertyDescriptors.OPAQUE) == false ? (Integer)widget.getProperty(PropertyDescriptors.ALPHA) : Integer.valueOf(255);
        PieChartFigure figure = this.getFigure();
        PieChart pieChart = figure.getChart();
        pieChart.setExplosion(((Integer)widget.getProperty(GraphPropertyDescriptors.PIE_CHART_EXPLOSION)).intValue());
        pieChart.setInnerRadius(Double.valueOf(((Integer)widget.getProperty(GraphPropertyDescriptors.PIE_CHART_INNER_RADIUS)).doubleValue()));
        Map<INode, Double> status = PieChartWidgetGraphicalEditPart.status(widget);
        List<PieData> datas = PieChartWidgetGraphicalEditPart.getDatas(status, alpha);
        pieChart.setDatas(datas);
        pieChart.getLegend().setVisible(false);
        Boolean labelIsDisplayed = (Boolean)widget.getProperty(GraphPropertyDescriptors.PIE_CHART_DISPLAY_LABEL);
        pieChart.setDisplayLabels(labelIsDisplayed.booleanValue());
        SWTUtils.getDisplay().syncExec(figure::regenerateChart);
    }

    private void activate(INode node) {
        for (INodeRelation relation : node.getRelations(new TypeDescriptor[]{ElementTypes.RELATION_HIERARCHY})) {
            relation.getTarget().registerPropertiesListener((IPropertiesListener)this);
            relation.getTarget().registerRelationsListener((INodeRelationListener)this);
            this.activate(relation.getTarget());
        }
    }

    private void deactivate(INode node) {
        for (INodeRelation relation : node.getRelations(new TypeDescriptor[]{ElementTypes.RELATION_HIERARCHY})) {
            relation.getTarget().unregisterPropertiesListener((IPropertiesListener)this);
            relation.getTarget().unregisterRelationsListener((INodeRelationListener)this);
            this.activate(relation.getTarget());
        }
    }

    private static class PieChartRefresher
    extends Observable {
        public PieChartRefresher() {
            new Thread(() -> {
                while (true) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.setChanged();
                    this.notifyObservers();
                }
            }).start();
        }
    }
}

