/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.widgets.ui.wizards;

import com.centreon.studio.client.commons.jface.StudioRegistries;
import com.centreon.studio.client.commons.jface.validation.field.impl.TextField;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.AObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyFormatter;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.repository.IRepositoryListener;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardPage;
import com.centreon.studio.client.system.commands.messages.SystemCommandMessages;
import com.centreon.studio.client.utils.SequenceUtils;
import com.centreon.studio.map.client.elements.widgets.messages.WidgetMessages;
import com.centreon.studio.map.client.resources.model.ResourcePropertyDescriptors;
import com.centreon.studio.map.client.status.model.StatusPropertyDescriptors;
import com.centreon.studio.map.client.status.model.StatusTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class OutputWidgetMetricWizardPage
extends CustomWizardPage
implements IRepositoryListener {
    private static final int NB_SERVICE_PROPERTIES_TO_DISPLAY = 22;
    private static final int NB_METRIC_PROPERTIES_TO_DISPLAY = 10;
    private static List<PropertyDescriptor<?>> SERVICE_PROPERTIES_TO_DISPLAY = new ArrayList(22);
    private static List<PropertyDescriptor<?>> METRIC_PROPERTIES_TO_DISPLAY = new ArrayList(10);
    private final List<String> autoCompleteProperties = new ArrayList<String>(22);
    private final List<String> autoCompleteMetrics = new ArrayList<String>(10);
    private TextField format;
    private Combo combo;
    private Table table;
    private final IRepository repository;

    static {
        SERVICE_PROPERTIES_TO_DISPLAY.add(ResourcePropertyDescriptors.CHECK_COMMAND);
        SERVICE_PROPERTIES_TO_DISPLAY.add(ResourcePropertyDescriptors.RESOURCE_NAME);
        SERVICE_PROPERTIES_TO_DISPLAY.add(ResourcePropertyDescriptors.PARENT_RESOURCE_NAME);
        SERVICE_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.CHECK_EXECUTION_TIME);
        SERVICE_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.CHECK_NEXT);
        SERVICE_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.CHECK_LAST);
        SERVICE_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.CHECK_LAST_UPDATE);
        SERVICE_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.CHECK_LATENCY);
        SERVICE_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.STATUS_TYPE);
        SERVICE_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.STATUS_OUTPUT);
        SERVICE_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.STATUS_EXTENDED_OUTPUT);
        SERVICE_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.STATUS_LAST_CHANGE);
        SERVICE_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.STATUS_LAST_OK);
        SERVICE_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.STATUS_LAST_UP);
        SERVICE_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.STATUS_LAST_DOWN);
        SERVICE_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.STATUS_LAST_WARNING);
        SERVICE_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.STATUS_LAST_UNKNOWN);
        SERVICE_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.STATUS_LAST_CRITICAL);
        SERVICE_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.STATUS_LAST_UNREACHABLE);
        SERVICE_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.STATUS_CHANGE_PERCENT);
        SERVICE_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.STATUS_PERFDATA);
        SERVICE_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.NOTIFICATION_NUMBER);
        METRIC_PROPERTIES_TO_DISPLAY.add(AObject.LABEL);
        METRIC_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.METRIC_MAX);
        METRIC_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.METRIC_MIN);
        METRIC_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.METRIC_UNIT);
        METRIC_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.METRIC_WARN);
        METRIC_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.METRIC_CRIT);
        METRIC_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.METRIC_VALUE);
        METRIC_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.METRIC_CRIT_LOW);
        METRIC_PROPERTIES_TO_DISPLAY.add(StatusPropertyDescriptors.METRIC_WARN_LOW);
    }

    public OutputWidgetMetricWizardPage(IRepository repository) {
        super(WidgetMessages.outputConfiguration);
        this.repository = repository;
        this.repository.registerSelectionListener((IRepositoryListener)this);
        this.setTitle(WidgetMessages.outputConfiguration);
        this.setDescription(WidgetMessages.outputWidgetWizardDescription);
    }

    public Composite customCreateControl(Composite parent) {
        Composite composite = SWTUtils.createComposite((Composite)parent, (int)2, (boolean)true, (int)5, (int)5);
        Font boldFont = StudioRegistries.fontRegistry().getBold("org.eclipse.jface.dialogfont");
        SWTUtils.createLabel((Composite)composite, (String)StatusPropertyDescriptors.OUTPUT_WIDGET_FORMAT.label, (int)1, (int)1, (int)-1, (int)-1).setFont(boldFont);
        GridData data = SWTUtils.createGridData((int)4, (int)1, (int)-1, (int)80);
        data.horizontalSpan = 2;
        Text formatText = SWTUtils.createText((Composite)composite, (int)2626, (int)80, (int)-1);
        formatText.setLayoutData((Object)data);
        this.format = new TextField(formatText, null, (String)this.getInput().getTarget().getProperty(StatusPropertyDescriptors.OUTPUT_WIDGET_FORMAT), this.getForm(), null);
        GridData comboCompositeGridData = SWTUtils.createGridDataHorizontalFill();
        comboCompositeGridData.horizontalSpan = 2;
        Composite comboComposite = SWTUtils.createComposite((Composite)composite, (int)2, (boolean)false, (int)0, (int)5, (GridData)comboCompositeGridData);
        SWTUtils.createLabel((Composite)comboComposite, (String)WidgetMessages.selectAMetric, (int)16384, (int)0x1000000, (int)-1, (int)-1).setFont(boldFont);
        this.combo = SWTUtils.createCombo((Composite)comboComposite, (int)2048, null, (GridData)SWTUtils.createGridData((int)1, (int)0x1000000, (int)250, (int)30), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = OutputWidgetMetricWizardPage.this.combo.getSelectionIndex();
                INode object = (INode)OutputWidgetMetricWizardPage.this.combo.getData(String.valueOf(index));
                OutputWidgetMetricWizardPage.this.refreshTable(object);
            }
        });
        this.redrawCombo();
        GridData tableData = new GridData(4, 4, true, true);
        tableData.horizontalSpan = 2;
        tableData.heightHint = 200;
        tableData.widthHint = 600;
        this.table = new Table(composite, 67586);
        this.table.setLayoutData((Object)tableData);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        new TableColumn(this.table, 0).setText(SystemCommandMessages.macroColumnName);
        new TableColumn(this.table, 0).setText(SystemCommandMessages.macroColumnDescription);
        new TableColumn(this.table, 0).setText(WidgetMessages.actualValue);
        this.refreshTable(null);
        this.table.addListener(8, event -> {
            Point pt = new Point(event.x, event.y);
            TableItem item = this.table.getItem(pt);
            if (item != null) {
                String newValue = "#" + item.getText(0);
                if (this.combo.getSelectionIndex() > 0) {
                    newValue = String.valueOf(newValue) + "@" + this.combo.getItem(this.combo.getSelectionIndex());
                }
                newValue = String.valueOf(newValue) + "#";
                int cursorPosition = ((Text)this.format.getControl()).getSelection().x;
                int newPosition = cursorPosition + newValue.length();
                String newOutput = String.valueOf(this.format.getValue().substring(0, cursorPosition)) + newValue + this.format.getValue().substring(cursorPosition, this.format.getValue().length());
                this.format.setValue((Object)newOutput);
                ((Text)this.format.getControl()).setSelection(newPosition);
            }
        });
        SWTUtils.createLabel((Composite)composite, (String)WidgetMessages.useShortcuts, (int)1, (int)16384, (int)128, (int)-1).setFont(boldFont);
        SWTUtils.createLabel((Composite)composite, (String)WidgetMessages.howItWorks, (int)1, (int)16384, (int)128, (int)-1).setFont(boldFont);
        SWTUtils.createLabel((Composite)composite, (String)WidgetMessages.outputShortcutsExplanation, (int)16384, (int)128, (int)-1, (int)-1);
        SWTUtils.createLabel((Composite)composite, (String)WidgetMessages.outputExplanation, (int)16384, (int)128, (int)-1, (int)-1);
        return composite;
    }

    public void dispose() {
        super.dispose();
        this.repository.unregisterSelectionListener((IRepositoryListener)this);
    }

    public Point getPageSize() {
        return new Point(800, 600);
    }

    public void selectionChanged(Object source, IRepository repository) {
        INodeRelation relation = repository.getSelection();
        if (relation == null || this.getInput() == null) {
            return;
        }
        this.getInput().getTarget().removeRelations((Collection)this.getInput().getTarget().getRelations(new TypeDescriptor[]{StatusTypes.METRIC}));
        for (INodeRelation metricRelation : relation.getTarget().getRelations(new TypeDescriptor[]{StatusTypes.METRIC})) {
            INode target = metricRelation.getTarget();
            Collection properties = target.getPropertyValues();
            INodeRelation newRelation = NodeRelationFactories.INSTANCE.create(StatusTypes.METRIC, SequenceUtils.next(), this.getInput().getTarget(), target, properties);
            this.getInput().getTarget().addRelation(newRelation);
        }
        this.refreshPage(relation);
    }

    protected boolean performFinish() {
        this.getInput().getTarget().addPropertyValue(StatusPropertyDescriptors.OUTPUT_WIDGET_FORMAT, (Object)this.format.getValue());
        return true;
    }

    protected void setInput(INodeRelation input) {
        if (input == null) {
            return;
        }
        super.setInput(input);
        if (this.combo == null) {
            this.refreshProposals(input);
            return;
        }
        this.refreshPage(input);
    }

    private void redrawCombo() {
        List metricRelations = this.getInput().getTarget().getRelations(new TypeDescriptor[]{StatusTypes.METRIC});
        this.combo.add("");
        this.combo.setData(String.valueOf(0), null);
        for (INodeRelation relation : metricRelations) {
            this.combo.setData(String.valueOf(this.combo.getItemCount()), (Object)relation.getTarget());
            this.combo.add(relation.getTarget().getLabel());
        }
    }

    private void refreshPage(INodeRelation relation) {
        if (this.combo == null) {
            return;
        }
        this.combo.removeAll();
        this.redrawCombo();
        this.refreshTable(null);
        this.autoCompleteMetrics.clear();
        for (INodeRelation r : relation.getTarget().getRelations(new TypeDescriptor[]{StatusTypes.METRIC})) {
            this.autoCompleteMetrics.add(r.getTarget().getLabel());
        }
        this.refreshProposals(relation);
    }

    private void refreshProposals(INodeRelation relation) {
        this.autoCompleteProperties.clear();
        for (PropertyValue pv : relation.getTarget().getPropertyValues()) {
            this.autoCompleteProperties.add("#" + pv.getProperty().id + "#");
        }
        for (INodeRelation metricRelation : relation.getTarget().getRelations(new TypeDescriptor[]{StatusTypes.METRIC})) {
            for (PropertyValue pv : metricRelation.getTarget().getPropertyValues()) {
                this.autoCompleteProperties.add("#" + pv.getProperty().id + "#");
            }
        }
    }

    private void refreshTable(INode metric) {
        this.table.removeAll();
        HashMap<PropertyDescriptor, String> properties = new HashMap<PropertyDescriptor, String>(SERVICE_PROPERTIES_TO_DISPLAY.size());
        List<PropertyDescriptor<?>> referenceCollection = metric == null ? SERVICE_PROPERTIES_TO_DISPLAY : METRIC_PROPERTIES_TO_DISPLAY;
        INode node = metric == null ? this.getInput().getTarget() : metric;
        for (PropertyDescriptor propertyDescriptor : referenceCollection) {
            Object value = node.getProperty(propertyDescriptor);
            if (value != null) {
                PropertyFormatter pt = PropertyFormatter.getPropetyFormatter((Class)propertyDescriptor.clazz);
                if (pt != null) {
                    properties.put(propertyDescriptor, pt.toString(value));
                    continue;
                }
                properties.put(propertyDescriptor, value.toString());
                continue;
            }
            properties.put(propertyDescriptor, "");
        }
        List<PropertyDescriptor> list = properties.keySet().stream().sorted((e1, e2) -> e1.id.compareTo(e2.id)).collect(Collectors.toList());
        list.forEach(e -> {
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, e.id);
            item.setText(1, e.label);
            item.setText(2, ((String)properties.get(e)).trim());
        });
        int i = 0;
        while (i < 3) {
            this.table.getColumn(i).pack();
            ++i;
        }
    }
}

