/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.widgets.ui.wizards;

import com.centreon.studio.client.model.decoration.repository.RepositoryDecorator;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.dialogs.CustomWizard;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardDialog;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardPage;
import com.centreon.studio.client.model.ui.dialogs.IWizardFactory;
import com.centreon.studio.map.client.elements.model.repository.decorators.ElementRepositoryDecorator;
import com.centreon.studio.map.client.elements.model.ui.wizards.MetricWizardPage;
import com.centreon.studio.map.client.elements.model.ui.wizards.ResourceWizardPage;
import com.centreon.studio.map.client.elements.widgets.messages.WidgetMessages;
import com.centreon.studio.map.client.elements.widgets.model.WidgetNodeFactory;
import com.centreon.studio.map.client.elements.widgets.model.WidgetTypes;
import com.centreon.studio.map.client.elements.widgets.ui.wizards.GaugeWidgetPropertiesWizardPage;
import com.centreon.studio.map.client.elements.widgets.ui.wizards.LinesChartWidgetMetricsWizardPage;
import com.centreon.studio.map.client.elements.widgets.ui.wizards.LinesChartWidgetPropertiesWizardPage;
import com.centreon.studio.map.client.elements.widgets.ui.wizards.OutputWidgetMetricWizardPage;
import com.centreon.studio.map.client.elements.widgets.ui.wizards.OutputWidgetPropertiesWizardPage;
import com.centreon.studio.map.client.elements.widgets.ui.wizards.PieChartWidgetPropertiesWizardPage;
import com.centreon.studio.map.client.resources.model.ResourceTypes;
import com.centreon.studio.map.client.resources.model.repository.decorators.ResourceRepositoryDecorator;
import com.centreon.studio.map.client.status.GraphWebService;
import com.centreon.studio.map.client.status.model.StatusTypes;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public enum WidgetWizardFactory implements IWizardFactory
{
    INSTANCE;


    public CustomWizardDialog createDialog(INodeRelation input, IEclipseContext context) {
        if (input == null) {
            return null;
        }
        ResourceRepositoryDecorator resourceRepositoryDecorator = (ResourceRepositoryDecorator)ContextInjectionFactory.make(ResourceRepositoryDecorator.class, (IEclipseContext)context);
        resourceRepositoryDecorator.setSelection((Object)this, null);
        INode decoratedHostRepository = INodeUtils.findNode((INode)resourceRepositoryDecorator, (TypeDescriptor)ResourceTypes.RESOURCE_HOST, null, (PropertyValue[])new PropertyValue[0]);
        List<TypeDescriptor> exclude = Arrays.asList(ResourceTypes.RESOURCE_SERVICE, StatusTypes.METRIC);
        RepositoryDecorator elementRepositoryDecorator = (RepositoryDecorator)ContextInjectionFactory.make(ElementRepositoryDecorator.class, (IEclipseContext)context);
        CustomWizard wizard = null;
        TypeDescriptor widgetType = input.getTarget().getType();
        if (WidgetTypes.WIDGET_OUTPUT.equals((Object)widgetType)) {
            wizard = new CustomWizard(WidgetMessages.outputWizardPageTitle);
            wizard.registerPage((CustomWizardPage)new OutputWidgetPropertiesWizardPage());
            wizard.registerPage((CustomWizardPage)new ResourceWizardPage((INode)resourceRepositoryDecorator, elementRepositoryDecorator, Arrays.asList(ResourceTypes.RESOURCE_SERVICE, ResourceTypes.RESOURCE_SERVICE_META), WidgetMessages.resourcePageLabel, exclude, new TypeDescriptor[]{ResourceTypes.RESOURCE_RELATION, ResourceTypes.RESOURCE_RELATION_LEAF}));
            wizard.registerPage((CustomWizardPage)new OutputWidgetMetricWizardPage((IRepository)resourceRepositoryDecorator));
        } else if (WidgetTypes.WIDGET_GAUGE.equals((Object)widgetType)) {
            wizard = new CustomWizard(WidgetMessages.gaugeWizardPageTitle);
            wizard.registerPage((CustomWizardPage)new GaugeWidgetPropertiesWizardPage());
            wizard.registerPage((CustomWizardPage)new ResourceWizardPage(decoratedHostRepository, elementRepositoryDecorator, Arrays.asList(ResourceTypes.RESOURCE_SERVICE), WidgetMessages.resourcePageLabel, exclude, new TypeDescriptor[]{ResourceTypes.RESOURCE_RELATION, ResourceTypes.RESOURCE_RELATION_LEAF}));
            wizard.registerPage((CustomWizardPage)new MetricWizardPage((IRepository)resourceRepositoryDecorator));
        } else if (WidgetTypes.WIDGET_PIE_CHART.equals((Object)widgetType)) {
            List accepted = ResourceTypes.getAll();
            accepted.removeAll(ResourceTypes.getNoChild());
            wizard = new CustomWizard(WidgetMessages.pieWizardPageTitle);
            wizard.registerPage((CustomWizardPage)new PieChartWidgetPropertiesWizardPage());
            wizard.registerPage((CustomWizardPage)new ResourceWizardPage((INode)resourceRepositoryDecorator, elementRepositoryDecorator, (Collection)accepted, WidgetMessages.resourcePageLabel, exclude, new TypeDescriptor[]{ResourceTypes.RESOURCE_RELATION}));
        } else if (WidgetTypes.WIDGET_LINE_CHART.equals((Object)widgetType)) {
            wizard = new CustomWizard(WidgetMessages.chartWizardPageTitle);
            wizard.registerPage((CustomWizardPage)new LinesChartWidgetPropertiesWizardPage());
            wizard.registerPage((CustomWizardPage)new ResourceWizardPage(decoratedHostRepository, elementRepositoryDecorator, Arrays.asList(ResourceTypes.RESOURCE_SERVICE), WidgetMessages.resourcePageLabel, exclude, new TypeDescriptor[]{ResourceTypes.RESOURCE_RELATION, ResourceTypes.RESOURCE_RELATION_LEAF}));
            if (!input.getTarget().getRelations(new TypeDescriptor[]{StatusTypes.METRIC}).isEmpty()) {
                GraphWebService service = (GraphWebService)ContextInjectionFactory.make(GraphWebService.class, (IEclipseContext)context);
                wizard.registerPage((CustomWizardPage)new LinesChartWidgetMetricsWizardPage(service, resourceRepositoryDecorator));
            }
        }
        if (wizard == null) {
            return null;
        }
        CustomWizardDialog dialog = new CustomWizardDialog(wizard);
        dialog.setInput(Arrays.asList(input));
        return dialog;
    }

    public Set<TypeDescriptor> getSupportedTypes() {
        return new HashSet<TypeDescriptor>(new WidgetNodeFactory().getSupportedTypes());
    }
}

