/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions;

import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.ARepositoryAction;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.messages.ModelUiMessages;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.swt.SWT;

public final class SelectAllAction
extends ARepositoryAction {
    private final TypeDescriptor[] relationTypes;
    private final boolean recursive;
    private final INode root;

    public SelectAllAction(IRepository input, INode root, boolean recursive, TypeDescriptor ... relationTypes) {
        super(ModelUiMessages.keywordSelectAll, input);
        this.relationTypes = relationTypes;
        this.recursive = recursive;
        this.root = root;
    }

    public final int getAccelerator() {
        return SWT.MOD1 | 0x41;
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean showInMenu() {
        return false;
    }

    @Override
    protected IUndoHandler internalRun() {
        INode actualRoot;
        LinkedList<INodeRelation> relations = new LinkedList<INodeRelation>();
        INodeRelation selection = this.getInput().getSelection();
        Object object = this.root != null ? this.root : (actualRoot = selection == null ? null : selection.getTarget());
        if (actualRoot == null) {
            return null;
        }
        this.addRelations(actualRoot, relations, this.recursive, this.relationTypes);
        this.getInput().setSelection((Object)this, relations);
        return null;
    }

    private void addRelations(INode node, Collection<INodeRelation> relations, boolean recursive, TypeDescriptor ... relationTypes) {
        relations.addAll(node.getRelations(relationTypes));
        if (recursive) {
            for (INodeRelation relation : node.getRelations(relationTypes)) {
                this.addRelations(relation.getTarget(), relations, recursive, relationTypes);
            }
        }
    }
}

