/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.common;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.StudioAction;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class StudioActionGroup
extends StudioAction
implements IMenuCreator {
    private final List<StudioAction> actions = new LinkedList<StudioAction>();

    public StudioActionGroup(String text) {
        super(text);
    }

    public void addAction(StudioAction action) {
        this.actions.add(action);
    }

    public void dispose() {
    }

    public Collection<StudioAction> getActions() {
        return Collections.unmodifiableCollection(this.actions);
    }

    public Menu getMenu(Control parent) {
        Menu menu = new Menu(parent);
        for (final StudioAction action : this.actions) {
            MenuItem item = new MenuItem(menu, action.getStyle());
            item.setImage(SWTUtils.getImageFromUrl((String)action.getImageDescriptorPath()));
            item.setAccelerator(action.getAccelerator());
            item.setText(action.getText());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    action.run();
                }
            });
        }
        return menu;
    }

    public Menu getMenu(Menu parent) {
        return this.getMenu(parent);
    }

    public IMenuCreator getMenuCreator() {
        return this;
    }

    public int getStyle() {
        return 4;
    }

    public boolean isEnabled() {
        boolean enabled = false;
        for (StudioAction action : this.actions) {
            enabled |= action.isEnabled();
        }
        return enabled;
    }

    @Override
    protected String getImageDescriptorPath() {
        if (this.actions.isEmpty()) {
            return null;
        }
        return this.actions.get(0).getImageDescriptorPath();
    }

    @Override
    protected IUndoHandler internalRun() {
        if (this.actions.isEmpty()) {
            return null;
        }
        return this.actions.get(0).internalRun();
    }
}

