/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.edit;

import com.centreon.studio.client.acl.ACLPropertyDescriptors;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.ARepositoryAction;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;

public abstract class AACLRepositoryAction
extends ARepositoryAction {
    protected final Collection<TypeDescriptor> excludedTypes = new ArrayList<TypeDescriptor>(20);
    protected final Collection<TypeDescriptor> supportedTypes = new ArrayList<TypeDescriptor>(20);
    protected PropertyDescriptor<Boolean> aclRightNeeded;
    private boolean singleSelectionAccepted;
    private boolean emptySelectionAccepted;
    private boolean multiSelectionAccepted;
    private boolean isACLAppliedOnSource;
    private boolean isACLAppliedOnTarget;
    private boolean blockCreateInReadOnly;

    public AACLRepositoryAction(String text, IRepository input) {
        super(text, input);
        this.setACLAppliedOnTarget(true);
        Assert.isNotNull((Object)this.getInput());
    }

    protected void addExcludedTypes(Collection<TypeDescriptor> types) {
        this.excludedTypes.addAll(types);
    }

    protected void addSupportedTypes(Collection<TypeDescriptor> types) {
        this.supportedTypes.addAll(types);
    }

    protected boolean customIsEnabled() {
        return true;
    }

    public final boolean isEnabled() {
        if (this.selectionEmpty() && !this.emptySelectionAccepted || this.selectionSingle() && !this.singleSelectionAccepted || this.selectionMultiple() && !this.multiSelectionAccepted) {
            return false;
        }
        for (INodeRelation selection : this.getInput().getSelections()) {
            if (this.aclRightNeeded != null) {
                if (((Boolean)selection.getTarget().getProperty(PropertyDescriptors.READ_ONLY)).booleanValue() && (this.aclRightNeeded == ACLPropertyDescriptors.CAN_DELETE || this.aclRightNeeded == ACLPropertyDescriptors.CAN_CREATE && this.blockCreateInReadOnly)) {
                    return false;
                }
                if (this.isACLAppliedOnSource && Boolean.FALSE.equals(selection.getSource().getProperty(this.aclRightNeeded)) || this.isACLAppliedOnTarget && Boolean.FALSE.equals(selection.getTarget().getProperty(this.aclRightNeeded))) {
                    return false;
                }
            }
            if (!this.excludedTypes.contains(selection.getTarget().getType()) && (this.supportedTypes.isEmpty() || this.supportedTypes.contains(selection.getTarget().getType()))) continue;
            return false;
        }
        return this.customIsEnabled();
    }

    protected final void setACLAppliedOnSource(boolean isACLAppliedOnSource) {
        this.isACLAppliedOnSource = isACLAppliedOnSource;
    }

    private final void setACLAppliedOnTarget(boolean isACLAppliedOnTarget) {
        this.isACLAppliedOnTarget = isACLAppliedOnTarget;
    }

    protected final void setACLRightNeeded(PropertyDescriptor<Boolean> aclRightNeeded) {
        this.aclRightNeeded = aclRightNeeded;
    }

    public void setBlockCreateInReadOnly(boolean blockCreateInReadOnly) {
        this.blockCreateInReadOnly = blockCreateInReadOnly;
    }

    protected final void setSelectionEmptyAccepted(boolean emptySelectionAccepted) {
        this.emptySelectionAccepted = emptySelectionAccepted;
    }

    protected final void setSelectionMultiAccepted(boolean multiSelectionAccepted) {
        this.multiSelectionAccepted = multiSelectionAccepted;
    }

    protected final void setSelectionSingleAccepted(boolean singleSelectionAccepted) {
        this.singleSelectionAccepted = singleSelectionAccepted;
    }
}

