/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.edit;

import com.centreon.studio.client.acl.ACLPropertyDescriptors;
import com.centreon.studio.client.commons.messages.CommonsMessages;
import com.centreon.studio.client.model.StudioTypes;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.NodeClipboard;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.edit.AACLRepositoryAction;
import com.centreon.studio.client.model.ui.actions.edit.RemoveNodesAction;
import org.eclipse.swt.SWT;

public final class CopyNodesAction
extends AACLRepositoryAction {
    private final NodeClipboard clipboard;
    private final boolean cut;

    public CopyNodesAction(IRepository input, TypeDescriptor type, boolean cut) {
        super(cut ? CommonsMessages.keywordCut : CommonsMessages.keywordCopy, input);
        this.clipboard = NodeClipboard.getClipboard(type);
        this.cut = cut;
        this.setSelectionSingleAccepted(true);
        this.setSelectionMultiAccepted(true);
        if (cut) {
            this.setACLRightNeeded((PropertyDescriptor<Boolean>)ACLPropertyDescriptors.CAN_DELETE);
        } else {
            this.setACLRightNeeded((PropertyDescriptor<Boolean>)ACLPropertyDescriptors.CAN_READ);
        }
    }

    public final int getAccelerator() {
        if (this.cut) {
            return SWT.MOD1 | 0x58;
        }
        return SWT.MOD1 | 0x43;
    }

    @Override
    protected boolean customIsEnabled() {
        for (INodeRelation relation : this.getInput().getSelections()) {
            if (!StudioTypes.REPOSITORY.equals((Object)relation.getTarget().getType())) continue;
            return false;
        }
        return super.customIsEnabled();
    }

    @Override
    protected String getImageDescriptorPath() {
        if (this.cut) {
            return "platform:/plugin/com.centreon.studio.client.model.ui/icons/cut_edit.gif";
        }
        return "platform:/plugin/com.centreon.studio.client.model.ui/icons/copy_edit.gif";
    }

    @Override
    protected IUndoHandler internalRun() {
        this.clipboard.setRelations(this.getInput().getSelections());
        this.clipboard.setCut(this.cut);
        if (this.cut) {
            new RemoveNodesAction(this.getInput(), false, false, true).run();
        }
        return null;
    }
}

