/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.edit;

import com.centreon.studio.client.acl.ACLPropertyDescriptors;
import com.centreon.studio.client.commons.messages.CommonsMessages;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.PropertiesUndoHandler;
import com.centreon.studio.client.model.ui.actions.edit.AACLRepositoryAction;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardDialog;
import com.centreon.studio.client.model.ui.dialogs.WizardFactories;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.swt.SWT;

public class EditNodeRelationAction
extends AACLRepositoryAction {
    private final boolean allowReadOnly;
    private final IEclipseContext context;

    public EditNodeRelationAction(IRepository input, IEclipseContext context, boolean allowMultiple) {
        this(input, context, allowMultiple, true);
    }

    public EditNodeRelationAction(IRepository input, IEclipseContext context, boolean allowMultiple, boolean allowReadOnly) {
        super(CommonsMessages.keywordEdit, input);
        this.setACLRightNeeded((PropertyDescriptor<Boolean>)ACLPropertyDescriptors.CAN_UPDATE);
        this.setSelectionMultiAccepted(allowMultiple);
        this.setSelectionSingleAccepted(true);
        this.allowReadOnly = allowReadOnly;
        this.context = context;
    }

    public final int getAccelerator() {
        return SWT.MOD1 | 0x45;
    }

    @Override
    protected boolean customIsEnabled() {
        if (this.allowReadOnly) {
            return true;
        }
        for (INodeRelation selection : this.getInput().getSelections()) {
            if (!((Boolean)selection.getTarget().getProperty(PropertyDescriptors.READ_ONLY)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getImageDescriptorPath() {
        return "platform:/plugin/com.centreon.studio.client.commons/img/edit-small.png";
    }

    @Override
    protected final IUndoHandler internalRun() {
        List selections = this.getInput().getSelections();
        ArrayList<Object> objects = new ArrayList<Object>(selections.size() * 2);
        for (INodeRelation selection : selections) {
            objects.add(selection);
            objects.add(selection.getTarget());
        }
        PropertiesUndoHandler undoHandler = new PropertiesUndoHandler(objects, new PropertyDescriptor[0]);
        CustomWizardDialog dialog = WizardFactories.INSTANCE.createDialog(selections, this.context);
        if (dialog != null && dialog.open() == 0) {
            return undoHandler;
        }
        return null;
    }
}

