/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.edit;

import com.centreon.studio.client.acl.ACLPropertyDescriptors;
import com.centreon.studio.client.acl.ACLUtils;
import com.centreon.studio.client.commons.messages.CommonsMessages;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.NodeFactories;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.edit.ACreateNodeRelationAction;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardDialog;
import com.centreon.studio.client.model.ui.dialogs.WizardFactories;
import com.centreon.studio.client.utils.SequenceUtils;
import com.centreon.studio.client.utils.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class WizardCreateNodeRelationAction
extends ACreateNodeRelationAction {
    private final ACLUtils utils;
    private final IEclipseContext context;
    private final TypeDescriptor nodeType;
    private final TypeDescriptor relationType;

    public WizardCreateNodeRelationAction(IRepository repository, IEclipseContext context, TypeDescriptor nodeType, TypeDescriptor relationType, boolean empty) {
        this(CommonsMessages.keywordAdd, repository, context, nodeType, relationType, empty);
    }

    public WizardCreateNodeRelationAction(String text, IRepository repository, IEclipseContext context, TypeDescriptor nodeType, TypeDescriptor relationType, boolean empty) {
        super(text, repository);
        this.context = context;
        this.nodeType = nodeType;
        this.relationType = relationType;
        this.setSelectionEmptyAccepted(empty);
        this.utils = (ACLUtils)ContextInjectionFactory.make(ACLUtils.class, (IEclipseContext)context);
    }

    protected INode createNode() {
        return NodeFactories.INSTANCE.create(this.nodeType, SequenceUtils.next(), null, this.getInput());
    }

    @Override
    protected Collection<INodeRelation> createRelations() {
        INode child = this.createNode();
        if (child == null) {
            return Collections.emptyList();
        }
        INodeRelation relation = NodeRelationFactories.INSTANCE.create(this.relationType, SequenceUtils.next(), this.getParent(), child, Arrays.asList(new PropertyValue(PropertyDescriptors.POSITION, (Object)this.pos)));
        if (relation == null) {
            return Collections.emptyList();
        }
        CustomWizardDialog dialog = WizardFactories.INSTANCE.createDialog(relation, this.context);
        if (dialog != null && dialog.open() == 0) {
            return Arrays.asList(relation);
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean customIsEnabled() {
        if (!super.customIsEnabled()) {
            return false;
        }
        return this.utils.can(ACLPropertyDescriptors.CAN_CREATE, this.nodeType, Long.valueOf(-1L), true);
    }

    @Override
    protected Collection<TypeDescriptor> getChildrenTypes() {
        return Arrays.asList(this.nodeType);
    }

    @Override
    protected String getImageDescriptorPath() {
        return StringUtils.firstNotNullEmptyOrBlank((String[])new String[]{this.nodeType.getSmallImage(), super.getImageDescriptorPath()});
    }
}

