/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.layer;

import com.centreon.studio.client.acl.ACLPropertyDescriptors;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.PropertiesUndoHandler;
import com.centreon.studio.client.model.ui.actions.edit.AACLRepositoryAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public abstract class ALayerNodesAction
extends AACLRepositoryAction {
    private static final Set<TypeDescriptor> EXCLUDED_TYPES = new HashSet<TypeDescriptor>(20);
    protected final boolean up;

    public static void register(TypeDescriptor type) {
        EXCLUDED_TYPES.add(type);
    }

    protected ALayerNodesAction(String text, IRepository input, boolean up) {
        super(text, input);
        this.setACLRightNeeded((PropertyDescriptor<Boolean>)ACLPropertyDescriptors.CAN_UPDATE);
        this.addExcludedTypes(EXCLUDED_TYPES);
        this.setSelectionSingleAccepted(true);
        this.setSelectionMultiAccepted(true);
        this.up = up;
    }

    @Override
    protected boolean customIsEnabled() {
        for (INodeRelation relation : this.getInput().getSelections()) {
            if (this.getLayerName(relation).equals(relation.getTarget().getProperty(PropertyDescriptors.LAYER))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getImageDescriptorPath() {
        if (this.up) {
            return "platform:/plugin/com.centreon.studio.client.model.ui/icons/layer_up.png";
        }
        return "platform:/plugin/com.centreon.studio.client.model.ui/icons/layer_down.png";
    }

    protected abstract String getLayerName(INodeRelation var1);

    @Override
    protected final IUndoHandler internalRun() {
        ArrayList<INode> nodes = new ArrayList<INode>(this.getInput().getSelections().size());
        for (INodeRelation selection : this.getInput().getSelections()) {
            nodes.add(selection.getTarget());
        }
        PropertiesUndoHandler undo = new PropertiesUndoHandler(nodes, PropertyDescriptors.LAYER);
        for (INodeRelation selection : this.getInput().getSelections()) {
            selection.getTarget().addPropertyValue(PropertyDescriptors.LAYER, (Object)this.getLayerName(selection));
        }
        return undo;
    }
}

