/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.layout;

import com.centreon.studio.client.model.ListOfPos;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.PropertiesUndoHandler;
import com.centreon.studio.client.model.ui.actions.layout.ALayoutAction;
import java.util.ArrayList;
import java.util.List;

public class MoveNodesAction
extends ALayoutAction {
    private final Pos delta;

    public MoveNodesAction(IRepository input, Pos delta) {
        super(null, input, null);
        this.setSelectionSingleAccepted(true);
        this.delta = delta;
    }

    @Override
    protected IUndoHandler internalRun() {
        List<INodeRelation> actualSelections = this.getActualSelection();
        PropertiesUndoHandler undoHandler = new PropertiesUndoHandler(actualSelections, PropertyDescriptors.CURRENT_POSITION, PropertyDescriptors.POSITION);
        for (INodeRelation selection : actualSelections) {
            Pos position = (Pos)selection.getProperty(PropertyDescriptors.CURRENT_POSITION);
            Pos newPosition = position == Pos.NULL ? this.delta : position.plus(this.delta);
            ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>(2);
            properties.add(new PropertyValue(PropertyDescriptors.CURRENT_POSITION, null));
            properties.add(new PropertyValue(PropertyDescriptors.POSITION, (Object)newPosition));
            selection.addPropertyValues(properties);
            ListOfPos positions = (ListOfPos)selection.getTarget().getProperty(PropertyDescriptors.BENDPOINTS);
            if (positions == ListOfPos.EMPTY) continue;
            ListOfPos newPositions = new ListOfPos(positions.size());
            for (Pos pos : positions) {
                newPositions.add((Object)pos.plus(this.delta));
            }
            selection.getTarget().addPropertyValue(PropertyDescriptors.BENDPOINTS, (Object)newPositions);
        }
        return undoHandler;
    }
}

