/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.layout;

import com.centreon.studio.client.model.ListOfPos;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.LayoutUtils;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.PropertiesUndoHandler;
import com.centreon.studio.client.model.ui.actions.layout.ALayoutAction;
import java.util.ArrayList;
import java.util.List;

public final class ResizeNodesAction
extends ALayoutAction {
    private static final int NORTH = 1;
    private static final int SOUTH = 4;
    private static final int WEST = 8;
    private static final int EAST = 16;
    private final int orientation;
    private final Pos delta;

    public ResizeNodesAction(IRepository input, Pos delta, int orientation) {
        super(null, input, null);
        this.setSelectionSingleAccepted(true);
        this.orientation = orientation;
        this.delta = delta;
    }

    @Override
    protected IUndoHandler internalRun() {
        List<INodeRelation> actualSelections = this.getActualSelection();
        PropertiesUndoHandler undoHandler = new PropertiesUndoHandler(actualSelections, PropertyDescriptors.POSITION, PropertyDescriptors.DIMENSION);
        for (INodeRelation selection : actualSelections) {
            Pos currentDimension = (Pos)selection.getProperty(PropertyDescriptors.CURRENT_DIMENSION);
            Pos newDimension = currentDimension.plus(this.delta);
            if (newDimension.isEmpty()) {
                newDimension = Pos.NULL;
            }
            Pos minDim = LayoutUtils.INSTANCE.getMinDim(selection);
            newDimension = Pos.create((double)Math.max(newDimension.x, minDim.x), (double)Math.max(newDimension.y, minDim.y));
            Pos actualDelta = newDimension.minus(currentDimension);
            Pos newPos = (Pos)selection.getProperty(PropertyDescriptors.CURRENT_POSITION);
            Pos newDelta = actualDelta.div(2.0);
            if ((this.orientation & 8) != 0) {
                newPos = newPos.plus(-newDelta.x.doubleValue(), 0.0);
            } else if ((this.orientation & 0x10) != 0) {
                newPos = newPos.plus(newDelta.x.doubleValue(), 0.0);
            }
            if ((this.orientation & 1) != 0) {
                newPos = newPos.plus(0.0, -newDelta.y.doubleValue());
            } else if ((this.orientation & 4) != 0) {
                newPos = newPos.plus(0.0, newDelta.y.doubleValue());
            }
            ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>(2);
            properties.add(new PropertyValue(PropertyDescriptors.POSITION, (Object)newPos));
            properties.add(new PropertyValue(PropertyDescriptors.CURRENT_POSITION, null));
            properties.add(new PropertyValue(PropertyDescriptors.DIMENSION, (Object)newDimension));
            properties.add(new PropertyValue(PropertyDescriptors.CURRENT_DIMENSION, null));
            selection.addPropertyValues(properties);
            ListOfPos positions = (ListOfPos)selection.getTarget().getProperty(PropertyDescriptors.POINTS);
            if (positions == ListOfPos.EMPTY) continue;
            ListOfPos newPositions = new ListOfPos(positions.size());
            for (Pos pos : positions) {
                newPositions.add((Object)pos.div(currentDimension.div(newDimension)));
            }
            selection.getTarget().addPropertyValue(PropertyDescriptors.POINTS, (Object)newPositions);
        }
        return undoHandler;
    }
}

