/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.layout.distribute;

import com.centreon.studio.client.acl.ACLPropertyDescriptors;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.PropertiesUndoHandler;
import com.centreon.studio.client.model.ui.actions.layout.ALayoutAction;
import com.centreon.studio.client.model.ui.messages.ModelUiMessages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.SWT;

public abstract class ADistributeNodesAction
extends ALayoutAction {
    private static final Set<TypeDescriptor> SUPPORTED_TYPES = new HashSet<TypeDescriptor>(20);

    public static void register(TypeDescriptor type) {
        SUPPORTED_TYPES.add(type);
    }

    private static void arrange(Pos origin, Pos line, int spacing, List<INodeRelation> relations) {
        Pos halfLine = line.div(2.0);
        Pos cursor = origin.plus(-halfLine.x.doubleValue(), halfLine.y.doubleValue());
        int i = 0;
        for (INodeRelation relation : relations) {
            Pos dimension = (Pos)relation.getProperty(PropertyDescriptors.CURRENT_DIMENSION);
            if (i != 0) {
                cursor = cursor.plus(dimension.x / 2.0, 0.0);
            }
            ++i;
            relation.addPropertyValues(Arrays.asList(new PropertyValue(PropertyDescriptors.POSITION, (Object)cursor.minus(0.0, dimension.div((double)2.0).y.doubleValue())), new PropertyValue(PropertyDescriptors.CURRENT_POSITION, null)));
            cursor = cursor.plus(dimension.x / 2.0 + (double)spacing, 0.0);
        }
    }

    private static double getFirstBiggerSquare(int size) {
        double i = 0.0;
        double square = Math.pow(i, 2.0);
        while (square < (double)size) {
            square = Math.pow(i += 1.0, 2.0);
        }
        return square;
    }

    private static INodeRelation orderRelationsByXThenByY(Collection<INodeRelation> relations) {
        INodeRelation topLeftRelation = null;
        for (INodeRelation relation : relations) {
            if (topLeftRelation == null) {
                topLeftRelation = relation;
                continue;
            }
            Pos relationPosition = (Pos)relation.getProperty(PropertyDescriptors.CURRENT_POSITION);
            Pos topLeftPosition = (Pos)topLeftRelation.getProperty(PropertyDescriptors.CURRENT_POSITION);
            if (!(relationPosition.x < topLeftPosition.x) && (!relationPosition.x.equals(topLeftPosition.x) || !(relationPosition.y < topLeftPosition.y))) continue;
            topLeftRelation = relation;
        }
        return topLeftRelation;
    }

    private static INodeRelation orderRelationsByYThenByX(Collection<INodeRelation> relations) {
        INodeRelation topLeftRelation = null;
        for (INodeRelation relation : relations) {
            if (topLeftRelation == null) {
                topLeftRelation = relation;
                continue;
            }
            Pos relationPosition = (Pos)relation.getProperty(PropertyDescriptors.CURRENT_POSITION);
            Pos topLeftPosition = (Pos)topLeftRelation.getProperty(PropertyDescriptors.CURRENT_POSITION);
            if (!(relationPosition.y < topLeftPosition.y) && (!relationPosition.y.equals(topLeftPosition.y) || !(relationPosition.x < topLeftPosition.x))) continue;
            topLeftRelation = relation;
        }
        return topLeftRelation;
    }

    protected ADistributeNodesAction(IRepository repository) {
        super("", repository, Pos.class);
        this.setSelectionMultiAccepted(true);
        this.setACLRightNeeded((PropertyDescriptor<Boolean>)ACLPropertyDescriptors.CAN_UPDATE);
        this.addSupportedTypes(SUPPORTED_TYPES);
    }

    public int getAccelerator() {
        if (this.getRows() == 1) {
            return SWT.MOD1 | SWT.MOD2 | SWT.MOD3 | 0x48;
        }
        if (this.getColumns() == 1) {
            return SWT.MOD1 | SWT.MOD2 | SWT.MOD3 | 0x56;
        }
        return SWT.MOD1 | SWT.MOD2 | SWT.MOD3 | 0x44;
    }

    public String getText() {
        if (this.getRows() == 1) {
            return ModelUiMessages.horizontally;
        }
        if (this.getColumns() == 1) {
            return ModelUiMessages.vertically;
        }
        return ModelUiMessages.grid;
    }

    protected abstract int getColumns();

    @Override
    protected final String getImageDescriptorPath() {
        if (this.getRows() == 1) {
            return "platform:/plugin/com.centreon.studio.client.model.ui/icons/distribute_hor.gif";
        }
        if (this.getColumns() == 1) {
            return "platform:/plugin/com.centreon.studio.client.model.ui/icons/distribute_ver.gif";
        }
        return "platform:/plugin/com.centreon.studio.client.model.ui/icons/distribute.gif";
    }

    protected abstract int getRows();

    protected abstract int getSpacing();

    @Override
    protected IUndoHandler internalRun() {
        List<INodeRelation> selections = this.getActualSelection();
        double square = ADistributeNodesAction.getFirstBiggerSquare(selections.size());
        int side = (int)Math.ceil(Math.sqrt(square));
        int actualRow = this.getRows() != -1 ? this.getRows() : side;
        int actualColumns = this.getColumns() != -1 ? this.getColumns() : Math.min((int)Math.ceil(square / (double)actualRow), selections.size());
        ArrayList<INodeRelation> orderedCollection = new ArrayList<INodeRelation>(selections.size());
        while (!selections.isEmpty()) {
            INodeRelation topLeftRelation = actualRow == 1 ? ADistributeNodesAction.orderRelationsByXThenByY(selections) : ADistributeNodesAction.orderRelationsByYThenByX(selections);
            orderedCollection.add(topLeftRelation);
            selections.remove(topLeftRelation);
        }
        Pos start = Pos.create((double)Double.MAX_VALUE, (double)Double.MAX_VALUE);
        Pos end = Pos.create((double)Double.MIN_VALUE, (double)Double.MIN_VALUE);
        Pos total = Pos.NULL;
        Pos line = Pos.NULL;
        ArrayList<Pos> lines = new ArrayList<Pos>(actualRow);
        int index = 1;
        while (index <= orderedCollection.size()) {
            INodeRelation selection = (INodeRelation)orderedCollection.get(index - 1);
            Pos dimension = (Pos)selection.getProperty(PropertyDescriptors.CURRENT_DIMENSION);
            Pos position = (Pos)selection.getProperty(PropertyDescriptors.CURRENT_POSITION);
            Pos positionPlusDimension = position.plus(dimension.div(2.0));
            line = Pos.create((double)(line.x + dimension.x / 2.0 + (double)this.getSpacing()), (double)Math.max(dimension.y / 2.0, line.y));
            end = Pos.create((double)Math.max(end.x, positionPlusDimension.x), (double)Math.max(end.y, positionPlusDimension.y));
            start = Pos.create((double)Math.min(start.x, position.x - dimension.x / 2.0), (double)Math.min(start.y, position.y - dimension.y / 2.0));
            if (index % actualColumns == 0 || index == orderedCollection.size()) {
                line = line.minus((double)this.getSpacing(), 0.0);
                total = Pos.create((double)Math.max(total.x, line.x), (double)(total.y + line.y + (double)this.getSpacing()));
                lines.add(line);
                line = Pos.NULL;
            }
            ++index;
        }
        total = total.minus(0.0, (double)this.getSpacing());
        Pos center = start.plus(end.minus(start).div(2.0));
        center = center.minus(0.0, total.y / 2.0);
        PropertiesUndoHandler undoHandler = new PropertiesUndoHandler(orderedCollection, PropertyDescriptors.POSITION, PropertyDescriptors.CURRENT_DIMENSION);
        int index2 = 0;
        int i = 0;
        while (i < lines.size()) {
            line = (Pos)lines.get(i);
            center = center.plus(0.0, line.y.doubleValue());
            ADistributeNodesAction.arrange(center, line, this.getSpacing(), orderedCollection.subList(index2, Math.min(index2 + actualColumns, orderedCollection.size())));
            center = center.plus(0.0, line.y + (double)this.getSpacing());
            index2 += actualColumns;
            ++i;
        }
        return undoHandler;
    }
}

