/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.layout.match;

import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.PropertiesUndoHandler;
import com.centreon.studio.client.model.ui.actions.layout.ALayoutAction;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.SWT;

public abstract class AMatchNodesAction
extends ALayoutAction {
    public static final int MATCH_ON_FIRST = 1;
    public static final int MATCH_ON_MIN = 2;
    public static final int MATCH_ON_MAX = 3;
    private final char accelerator;
    private final String icon;
    private final int mode;

    protected AMatchNodesAction(IRepository input, String label, char accelerator, String icon, int mode) {
        super(label, input, Pos.class);
        this.accelerator = accelerator;
        this.mode = mode;
        this.icon = icon;
    }

    public final int getAccelerator() {
        return SWT.MOD1 | SWT.MOD2 | this.accelerator;
    }

    protected abstract Pos createNewPos(Pos var1, Pos var2);

    @Override
    protected final String getImageDescriptorPath() {
        return "platform:/plugin/com.centreon.studio.client.model.ui/icons/" + this.icon;
    }

    @Override
    protected IUndoHandler internalRun() {
        Pos match;
        List<INodeRelation> actualSelections = this.getActualSelection();
        PropertiesUndoHandler undoHandler = new PropertiesUndoHandler(actualSelections, PropertyDescriptors.CURRENT_DIMENSION, PropertyDescriptors.DIMENSION);
        Pos firstDimension = (Pos)actualSelections.get(0).getProperty(PropertyDescriptors.CURRENT_DIMENSION);
        Pos pos = match = this.mode == 1 ? firstDimension : Pos.create((double)0.0, (double)0.0);
        if (this.mode != 1) {
            for (INodeRelation selection : actualSelections) {
                Pos current = (Pos)selection.getProperty(PropertyDescriptors.CURRENT_DIMENSION);
                Pos pos2 = match = this.mode == 3 ? Pos.create((double)Math.max(match.x, current.x), (double)Math.max(match.y, current.y)) : Pos.create((double)Math.min(match.x, current.x), (double)Math.min(match.y, current.y));
            }
        }
        for (INodeRelation selection : actualSelections) {
            Pos newPos = this.createNewPos((Pos)selection.getProperty(PropertyDescriptors.CURRENT_DIMENSION), match);
            selection.addPropertyValues(Arrays.asList(new PropertyValue(PropertyDescriptors.DIMENSION, (Object)newPos), new PropertyValue(PropertyDescriptors.CURRENT_DIMENSION, null)));
        }
        return undoHandler;
    }
}

