/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.navigation;

import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.ui.actions.navigation.IOpenFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.contexts.IEclipseContext;

public enum OpenFactories implements IOpenFactory
{
    INSTANCE;

    private final Map<TypeDescriptor, IOpenFactory> factories = new HashMap<TypeDescriptor, IOpenFactory>(8);

    public Set<TypeDescriptor> getSupportedTypes() {
        return Collections.unmodifiableSet(this.factories.keySet());
    }

    @Override
    public boolean open(INodeRelation relation, IEclipseContext context) {
        IOpenFactory factory = this.factories.get(relation.getTarget().getType());
        if (factory != null) {
            return factory.open(relation, context);
        }
        return false;
    }

    public void register(IOpenFactory factory) {
        Assert.isTrue((factory != null && factory.getSupportedTypes() != null ? 1 : 0) != 0, (String)"factory and supported types must not be null");
        for (TypeDescriptor supportedType : factory.getSupportedTypes()) {
            this.factories.put(supportedType, factory);
        }
    }
}

