/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.navigation;

import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.edit.AACLRepositoryAction;
import com.centreon.studio.client.model.ui.actions.navigation.OpenFactories;
import com.centreon.studio.client.model.ui.messages.ModelUiMessages;
import java.lang.ref.WeakReference;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class OpenNodeAction
extends AACLRepositoryAction {
    private static final Deque<WeakReference<INodeRelation>> PREVIOUS = new ConcurrentLinkedDeque<WeakReference<INodeRelation>>();
    private static final Deque<WeakReference<INodeRelation>> NEXT = new ConcurrentLinkedDeque<WeakReference<INodeRelation>>();
    private final IEclipseContext context;

    public static boolean canOpenNext() {
        return !NEXT.isEmpty();
    }

    public static boolean canOpenPrevious() {
        return PREVIOUS.size() > 1;
    }

    public static void openNext(IEclipseContext context) {
        WeakReference<INodeRelation> ref = NEXT.pollFirst();
        if (ref != null && ref.get() != null) {
            INodeRelation relation = (INodeRelation)ref.get();
            if (relation != null) {
                PREVIOUS.addFirst(new WeakReference<INodeRelation>(relation));
                if (!OpenFactories.INSTANCE.open(relation, context)) {
                    OpenNodeAction.openNext(context);
                }
            } else {
                OpenNodeAction.openNext(context);
            }
        }
    }

    public static void openPrevious(IEclipseContext context) {
        WeakReference<INodeRelation> ref = PREVIOUS.pollFirst();
        if (ref != null && ref.get() != null) {
            INodeRelation relation = (INodeRelation)ref.get();
            if (relation != null) {
                NEXT.addFirst(new WeakReference<INodeRelation>(relation));
                if (!OpenFactories.INSTANCE.open(relation, context)) {
                    OpenNodeAction.openPrevious(context);
                }
            } else {
                OpenNodeAction.openPrevious(context);
            }
        }
    }

    public OpenNodeAction(IRepository repository, IEclipseContext context) {
        super(ModelUiMessages.open, repository);
        this.setSelectionSingleAccepted(true);
        this.setSelectionMultiAccepted(true);
        this.context = context;
    }

    public final int getAccelerator() {
        return 13;
    }

    @Override
    protected IUndoHandler internalRun() {
        for (INodeRelation selection : this.getInput().getSelections()) {
            if (!OpenFactories.INSTANCE.open(selection, this.context)) continue;
            PREVIOUS.addFirst(new WeakReference<INodeRelation>(selection));
            NEXT.clear();
        }
        return null;
    }
}

