/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actionsets;

import com.centreon.studio.client.model.ui.actions.common.StudioAction;
import com.centreon.studio.client.model.ui.actionsets.ActionSetContributor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.core.contexts.IEclipseContext;

public abstract class ActionSetDescriptor {
    private static final Map<Class<? extends ActionSetDescriptor>, List<ActionSetContributor>> CLAZZ_CONTRIBUTIONS = new HashMap<Class<? extends ActionSetDescriptor>, List<ActionSetContributor>>(8);
    private final IEclipseContext context;

    public static final void contribute(Class<? extends ActionSetDescriptor> clazz, ActionSetContributor contribution) {
        List<ActionSetContributor> contributions = CLAZZ_CONTRIBUTIONS.get(clazz);
        if (contributions == null) {
            contributions = new LinkedList<ActionSetContributor>();
            CLAZZ_CONTRIBUTIONS.put(clazz, contributions);
        }
        contributions.add(contribution);
    }

    public static final void uncontribute(Class<? extends ActionSetDescriptor> clazz, ActionSetContributor contribution) {
        List<ActionSetContributor> contributions = CLAZZ_CONTRIBUTIONS.get(clazz);
        if (contributions != null) {
            contributions.remove(contribution);
        }
    }

    protected ActionSetDescriptor(IEclipseContext context) {
        this.context = context;
    }

    public final List<StudioAction> getActions() {
        LinkedList<StudioAction> actions = new LinkedList<StudioAction>();
        actions.addAll(this.createActions());
        List<ActionSetContributor> contributions = CLAZZ_CONTRIBUTIONS.get(this.getClass());
        if (contributions != null) {
            for (ActionSetContributor contribution : contributions) {
                contribution.contribute(actions, this.context);
            }
        }
        return actions;
    }

    public abstract StudioAction getDefaultAction();

    protected abstract List<StudioAction> createActions();

    protected final IEclipseContext getContext() {
        return this.context;
    }
}

