/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.contributions;

import com.centreon.studio.client.model.ui.actions.common.StudioAction;
import com.centreon.studio.client.model.ui.contributions.StudioActionContributionItem;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;

public enum NodeActionContributionFactory {
    INSTANCE;

    private static final Class<? extends StudioActionContributionItem> DEFAULT_CONTRIBUTION;
    private final Map<Class<? extends IAction>, Class<? extends StudioActionContributionItem>> actionToContribution = new HashMap<Class<? extends IAction>, Class<? extends StudioActionContributionItem>>(8);

    static {
        DEFAULT_CONTRIBUTION = StudioActionContributionItem.class;
    }

    public StudioActionContributionItem createContribution(StudioAction action) {
        Class<?> actionClass = ((Object)((Object)action)).getClass();
        Class<? extends StudioActionContributionItem> contributionItemClass = this.actionToContribution.get(actionClass);
        if (contributionItemClass == null) {
            contributionItemClass = DEFAULT_CONTRIBUTION;
        }
        boolean accessible = false;
        Constructor<? extends StudioActionContributionItem> constructor = null;
        try {
            try {
                constructor = contributionItemClass.getDeclaredConstructor(StudioAction.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                constructor = contributionItemClass.getDeclaredConstructor(((Object)((Object)action)).getClass());
            }
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
                accessible = false;
            }
            StudioActionContributionItem studioActionContributionItem = constructor.newInstance(new Object[]{action});
            return studioActionContributionItem;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        finally {
            if (constructor != null && !accessible) {
                constructor.setAccessible(false);
            }
        }
        return null;
    }

    public void register(Class<? extends StudioAction> actionClass, Class<? extends StudioActionContributionItem> contributionClass) {
        this.actionToContribution.put(actionClass, contributionClass);
    }
}

