/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.controls.impl;

import com.centreon.studio.client.model.FilterData;
import com.centreon.studio.client.model.IFilter;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import java.util.ArrayList;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class FilterContentProvider
implements IContentProposalProvider {
    private final IFilter filter;

    public FilterContentProvider(IFilter filter) {
        this.filter = filter;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList<FilterDataContentProposal> proposals = new ArrayList<FilterDataContentProposal>(this.filter.getHistory().size());
        for (FilterData data : this.filter.getHistory()) {
            if (!data.value.startsWith(contents)) continue;
            proposals.add(new FilterDataContentProposal(data));
        }
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }

    private static class FilterDataContentProposal
    implements IContentProposal {
        private final FilterData data;

        private FilterDataContentProposal(FilterData data) {
            this.data = data;
        }

        public String getContent() {
            return this.data.value;
        }

        public int getCursorPosition() {
            return this.data.value.length();
        }

        public String getDescription() {
            return null;
        }

        public String getLabel() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.data.value);
            builder.append(", ");
            builder.append(this.data.caseSensitive ? "case sensitive" : "not case sensitive");
            builder.append(", ");
            builder.append(this.data.useRegex ? "using regex " : "not using regex");
            builder.append(", on ");
            for (PropertyDescriptor pd : this.data.descriptors) {
                builder.append(pd.label);
                builder.append(", ");
            }
            return builder.toString();
        }
    }
}

