/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.controls.impl;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.decoration.IIndexer;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeRelationListener;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.AObject;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.IPropertiesListener;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.repository.IRepositoryListener;
import com.centreon.studio.client.model.ui.controls.impl.OverlayIcon;
import com.centreon.studio.client.model.ui.controls.impl.OverlayPosition;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class NodeTreeContentProvider
implements ISelectionChangedListener,
ITreeContentProvider,
IRepositoryListener,
IPropertiesListener,
ILabelProvider,
IColorProvider,
INodeRelationListener {
    private final Collection<PropertyDescriptor<?>> properties = new TreeSet();
    private final Collection<WeakReference<INode>> models;
    private final TreeViewer viewer;
    private final TypeDescriptor[] types;
    private final IRepository repository;
    private volatile boolean updatingSelection;
    private final Map<PropertyDescriptor<Boolean>, ImageOverlay> imageOverlayMap;
    private boolean refreshOnRelationChanged;

    public NodeTreeContentProvider(TreeViewer viewer, IRepository repository, Collection<PropertyDescriptor<?>> properties, TypeDescriptor ... types) {
        this.properties.add(AObject.LABEL);
        this.properties.add(PropertyDescriptors.ACTIVE);
        this.properties.add(PropertyDescriptors.IMAGE_SMALL);
        this.models = new ArrayList<WeakReference<INode>>(64);
        this.imageOverlayMap = new HashMap<PropertyDescriptor<Boolean>, ImageOverlay>(4);
        this.refreshOnRelationChanged = true;
        this.types = types;
        this.viewer = viewer;
        this.repository = repository;
        if (properties != null) {
            this.properties.addAll(properties);
        }
        this.repository.registerSelectionListener((IRepositoryListener)this);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.repository.unregisterSelectionListener((IRepositoryListener)this);
        for (WeakReference<INode> reference : this.models) {
            INode model = (INode)reference.get();
            if (model == null) continue;
            model.unregisterRelationsListener((INodeRelationListener)this);
            model.unregisterPropertiesListener((IPropertiesListener)this);
        }
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        INodeRelation relation = (INodeRelation)parentElement;
        List relations = relation.getTarget().getRelations(this.types);
        this.register(relations);
        return relations.toArray(new Object[relations.size()]);
    }

    public Object[] getElements(Object inputElement) {
        INode input = (INode)inputElement;
        List relations = input.getRelations(this.types);
        this.register(relations);
        return relations.toArray(new Object[relations.size()]);
    }

    public Color getForeground(Object element) {
        INode target = ((INodeRelation)element).getTarget();
        if (!((Boolean)target.getProperty(PropertyDescriptors.ACTIVE)).booleanValue()) {
            return SWTUtils.getSystemColor((int)15);
        }
        return null;
    }

    public Image getImage(Object element) {
        INode target = ((INodeRelation)element).getTarget();
        Image defaultImage = SWTUtils.getImageFromUrl((String)((String)target.getProperty(PropertyDescriptors.IMAGE_SMALL)), (int)16, (int)16);
        if (!this.imageOverlayMap.entrySet().parallelStream().anyMatch(e -> (Boolean)target.getProperty((PropertyDescriptor)e.getKey()))) {
            return defaultImage;
        }
        ImageDescriptor id = ImageDescriptor.createFromImage((Image)defaultImage);
        OverlayIcon oi = new OverlayIcon(id, new Point(16, 16));
        for (Map.Entry<PropertyDescriptor<Boolean>, ImageOverlay> entry : this.imageOverlayMap.entrySet()) {
            if (!((Boolean)target.getProperty(entry.getKey())).booleanValue()) continue;
            ImageDescriptor icon = ImageDescriptor.createFromImage((Image)SWTUtils.getImageFromUrl((String)entry.getValue().imagePath, (int)8, (int)8));
            oi.addOverlayIcon(entry.getValue().position, icon);
        }
        return oi.createImage();
    }

    public Object getParent(Object element) {
        INode parentNode = ((INodeRelation)element).getSource();
        return INodeUtils.findRelationForTarget((INode)this.repository, (TypeDescriptor)parentNode.getType(), (Long)parentNode.getId(), (PropertyValue[])new PropertyValue[0]);
    }

    public String getText(Object element) {
        return ((INodeRelation)element).getTarget().getLabel();
    }

    public boolean hasChildren(Object element) {
        return !((INodeRelation)element).getTarget().getRelations(this.types).isEmpty();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        INode input;
        Assert.isTrue((oldInput == null || newInput == null ? 1 : 0) != 0);
        if (oldInput != null) {
            input = (INode)oldInput;
            input.unregisterPropertiesListener((IPropertiesListener)this);
            input.unregisterRelationsListener((INodeRelationListener)this);
        }
        if (newInput != null) {
            input = (INode)newInput;
            input.registerPropertiesListener((IPropertiesListener)this);
            input.registerRelationsListener((INodeRelationListener)this);
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.properties.contains(PropertyDescriptor.getPropertyDescriptor((String)property));
    }

    public void propertiesChanged(IObject object, Collection<PropertyValue> propertyValues) {
        for (PropertyValue value : propertyValues) {
            if (!this.properties.contains(value.getProperty())) continue;
            INode node = (INode)object;
            IIndexer indexer = (IIndexer)this.repository.adapt(IIndexer.class);
            if (indexer == null) {
                INodeRelation relationForTarget = INodeUtils.findRelationForTarget((INode)this.repository, (TypeDescriptor)node.getType(), (Long)node.getId(), (PropertyValue[])new PropertyValue[0]);
                SWTUtils.getDisplay().syncExec(() -> this.viewer.update((Object)relationForTarget, null));
                break;
            }
            Collection relations = indexer.getRelationsForTarget(node);
            SWTUtils.getDisplay().syncExec(() -> {
                for (INodeRelation relation : relations) {
                    this.viewer.update((Object)relation, null);
                }
            });
            break;
        }
    }

    public void registerImageOverlay(PropertyDescriptor<Boolean> pd, OverlayPosition position, String imagePath) {
        this.imageOverlayMap.put(pd, new ImageOverlay(position, imagePath));
        this.properties.add(pd);
    }

    public void relationsAdded(INode node, Collection<INodeRelation> relations) {
        if (this.refreshOnRelationChanged) {
            SWTUtils.getDisplay().syncExec(() -> this.refreshViewer(node, relations));
        }
    }

    public void relationsRemoved(INode node, Collection<INodeRelation> relations) {
        if (this.refreshOnRelationChanged) {
            SWTUtils.getDisplay().syncExec(() -> this.refreshViewer(node, relations));
        }
    }

    public boolean removeImageOverlay(PropertyDescriptor<Boolean> pd) {
        this.properties.remove(pd);
        return this.imageOverlayMap.remove(pd) != null;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void selectionChanged(Object source, IRepository repository) {
        SWTUtils.getDisplay().syncExec(() -> {
            if (source != this.viewer) {
                List selections = this.repository.getSelections();
                if (selections.isEmpty()) {
                    this.viewer.setSelection(null);
                    return;
                }
                ArrayList<INodeRelation> actualSelections = new ArrayList<INodeRelation>(selections.size());
                block0: for (INodeRelation selection : selections) {
                    TypeDescriptor[] typeDescriptorArray = this.types;
                    int n = this.types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TypeDescriptor type = typeDescriptorArray[n2];
                        if (selection.getType().equals((Object)type)) {
                            actualSelections.add(selection);
                            continue block0;
                        }
                        ++n2;
                    }
                }
                this.updatingSelection = true;
                if (!actualSelections.isEmpty()) {
                    this.viewer.setSelection((ISelection)new StructuredSelection(actualSelections));
                }
                this.updatingSelection = false;
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        SWTUtils.getDisplay().syncExec(() -> {
            if (this.updatingSelection) {
                return;
            }
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            if (selection.isEmpty()) {
                this.repository.setSelection((Object)this.viewer, null);
                return;
            }
            Object[] selectionArray = selection.toArray();
            ArrayList<INodeRelation> relations = new ArrayList<INodeRelation>(selectionArray.length);
            Object[] objectArray = selectionArray;
            int n = selectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                relations.add((INodeRelation)object);
                ++n2;
            }
            this.repository.setSelection((Object)this.viewer, relations);
        });
    }

    public void setRefreshOnRelationChanged(boolean refreshOnChange) {
        this.refreshOnRelationChanged = refreshOnChange;
    }

    private final void refreshViewer(INode node, Collection<INodeRelation> relations) {
        if (this.types == null) {
            if (!this.viewer.getControl().isDisposed()) {
                this.viewer.refresh((Object)node);
            }
        } else {
            List<TypeDescriptor> collectionTypes = Arrays.asList(this.types);
            relations.stream().filter(r -> collectionTypes.contains(r.getType())).findAny().ifPresent(r -> {
                INodeRelation parentRelation = INodeUtils.findRelationForTarget((INode)this.repository, (TypeDescriptor)node.getType(), (Long)node.getId(), (PropertyValue[])new PropertyValue[0]);
                if (!this.viewer.getControl().isDisposed()) {
                    if (parentRelation != null) {
                        this.viewer.refresh((Object)parentRelation);
                    } else {
                        this.viewer.refresh((Object)this.repository);
                    }
                }
            });
        }
    }

    private void register(Collection<INodeRelation> relations) {
        for (INodeRelation relation : relations) {
            relation.getTarget().registerPropertiesListener((IPropertiesListener)this);
            relation.getTarget().registerRelationsListener((INodeRelationListener)this);
            this.models.add(new WeakReference<INode>(relation.getTarget()));
        }
    }

    private class ImageOverlay {
        protected OverlayPosition position;
        protected String imagePath;

        public ImageOverlay(OverlayPosition position, String imagePath) {
            this.position = position;
            this.imagePath = imagePath;
        }
    }
}

