/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.controls.impl;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.ui.actions.edit.CopyNodesAction;
import com.centreon.studio.client.model.ui.actionsets.ActionSetDescriptor;
import com.centreon.studio.client.model.ui.controls.abs.ANodeViewer;
import com.centreon.studio.client.model.ui.controls.impl.NodeTreeContentProvider;
import com.centreon.studio.client.model.ui.controls.impl.NodeViewerFilter;
import com.centreon.studio.client.model.ui.controls.impl.OverlayPosition;
import com.centreon.studio.client.model.ui.controls.impl.RepositoryDragSourceListenner;
import com.centreon.studio.client.model.ui.controls.impl.listeners.ActionSetDescriptorListener;
import com.centreon.studio.client.model.ui.dnd.NodeTransfer;
import com.centreon.studio.client.model.ui.dnd.drop.INodeDropTargetListener;
import com.centreon.studio.client.model.ui.dnd.drop.NodeDropTarget;
import java.util.Collection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;

public class NodeTreeViewer
extends ANodeViewer<Tree>
implements Listener {
    private final Collection<PropertyDescriptor<?>> properties;
    private final NodeViewerFilter filter;
    private NodeDropTarget dropTarget;
    private TreeViewer viewer;
    private NodeTreeContentProvider provider;

    public NodeTreeViewer(Composite parent, INode node, NodeViewerFilter filter, Collection<PropertyDescriptor<?>> properties, TypeDescriptor ... relationType) {
        super(parent, node, relationType);
        this.properties = properties;
        this.filter = filter;
        this.initControl();
    }

    public final void addDropTargetListener(INodeDropTargetListener listener) {
        if (this.dropTarget == null) {
            this.dropTarget = new NodeDropTarget((Control)this.getControl(), 2003);
        }
        this.dropTarget.addListener(listener);
    }

    public void addFilter(ViewerFilter anotherFilter) {
        this.viewer.addFilter(anotherFilter);
    }

    public void addImageOverlay(PropertyDescriptor<Boolean> pd, OverlayPosition position, String imagePath) {
        this.getContentProvider().registerImageOverlay(pd, position, imagePath);
    }

    public void handleEvent(Event e) {
        if (e.type == 4) {
            boolean selectionNotEmpty;
            boolean itemNotFound = ((Tree)this.getControl()).getItem(new Point(e.x, e.y)) == null;
            boolean bl = selectionNotEmpty = this.getInput().getRepository().getSelection() != null;
            if (itemNotFound && selectionNotEmpty) {
                this.viewer.setSelection(null);
                this.getInput().getRepository().setSelection((Object)this.viewer, null);
            }
        } else if (e.type == 2) {
            if (e.stateMask == SWT.MOD1 && e.keyCode == 16777259 || e.stateMask == (SWT.MOD3 | SWT.MOD2) && e.keyCode == 112) {
                this.viewer.expandAll();
            } else if (e.stateMask == SWT.MOD1 && e.keyCode == 16777261 || e.stateMask == (SWT.MOD3 | SWT.MOD2) && e.keyCode == 109) {
                this.viewer.collapseAll();
            }
        }
    }

    public void refresh() {
        SWTUtils.getDisplay().syncExec(() -> {
            if (this.viewer.getTree().isDisposed()) {
                return;
            }
            this.viewer.refresh();
        });
    }

    public final void setActionSetDescriptor(ActionSetDescriptor actionSet) {
        if (actionSet != null) {
            ActionSetDescriptorListener actionListener = new ActionSetDescriptorListener(actionSet);
            ((Tree)this.getControl()).addMouseListener((MouseListener)actionListener);
            ((Tree)this.getControl()).addKeyListener((KeyListener)actionListener);
        }
    }

    public final void setDragSource(CopyNodesAction action, boolean fixedSource) {
        DragSource dragSource = new DragSource(this.getControl(), 3);
        dragSource.setTransfer(new Transfer[]{NodeTransfer.getInstance()});
        dragSource.addDragListener((DragSourceListener)new RepositoryDragSourceListenner(this.getInput().getRepository(), action, fixedSource));
    }

    public void setRefreshOnRelationChanged(boolean refreshOnChange) {
        this.provider.setRefreshOnRelationChanged(refreshOnChange);
    }

    @Override
    protected Tree createControl(Composite parent) {
        Tree tree = new Tree(parent, 2);
        tree.setLayoutData((Object)SWTUtils.createGridDataFill());
        tree.addListener(4, (Listener)this);
        tree.addListener(2, (Listener)this);
        return tree;
    }

    @Override
    protected void initControl() {
        this.viewer = new TreeViewer((Tree)this.getControl());
        this.viewer.setUseHashlookup(true);
        this.provider = new NodeTreeContentProvider(this.viewer, this.getInput().getRepository(), this.properties, this.getRelationTypes());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.provider);
        this.viewer.setContentProvider((IContentProvider)this.provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.provider);
        this.viewer.setInput((Object)this.getInput());
        if (this.filter != null) {
            this.viewer.setExpandPreCheckFilters(true);
            this.viewer.setFilters(new ViewerFilter[]{this.filter});
            this.filter.setViewer(this.viewer);
        }
        this.provider.selectionChanged(this, null);
    }

    private NodeTreeContentProvider getContentProvider() {
        return (NodeTreeContentProvider)this.viewer.getContentProvider();
    }
}

