/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.controls.impl;

import com.centreon.studio.client.model.FilterData;
import com.centreon.studio.client.model.IFilter;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class NodeViewerFilter
extends ViewerFilter
implements IFilter {
    private FilterData filterData;
    private final List<FilterData> history;
    private final Collection<PropertyDescriptor<?>> candidateProperties;
    private TreeViewer viewer;

    public NodeViewerFilter(Collection<PropertyDescriptor<?>> candidateProperties, Collection<TypeDescriptor> exclude, TypeDescriptor ... relationTypes) {
        Assert.isTrue((candidateProperties != null && !candidateProperties.isEmpty() ? 1 : 0) != 0, (String)"candidate properties must not be null or empty");
        this.candidateProperties = candidateProperties;
        this.filterData = new FilterData("", false, false, candidateProperties, exclude, relationTypes);
        this.history = new LinkedList<FilterData>();
    }

    public Collection<PropertyDescriptor<?>> getCandidateProperties() {
        return this.candidateProperties;
    }

    public FilterData getFilterData() {
        return this.filterData;
    }

    public List<FilterData> getHistory() {
        return this.history;
    }

    public boolean isFilterProperty(Object element, String property) {
        for (PropertyDescriptor pd : this.filterData.descriptors) {
            if (!pd.id.equals(property)) continue;
            return true;
        }
        return false;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return !this.filterData.filter((INodeRelation)element);
    }

    public void setFilterData(FilterData data) {
        boolean unfilter = this.filterData.needUnfilterTo(data);
        boolean filter = this.filterData.needFilterTo(data);
        if (unfilter || filter) {
            if (!data.value.isEmpty()) {
                this.history.remove(data);
                this.history.add(data);
            }
            this.filterData = data;
            this.viewer.collapseAll();
            this.viewer.refresh();
            if (filter) {
                this.viewer.expandToLevel(2);
            }
        }
    }

    public void setViewer(TreeViewer viewer) {
        this.viewer = viewer;
    }
}

