/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.dialogs;

import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.repository.IRepositoryListener;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardPage;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.graphics.Point;

public abstract class AbstractRepositoryCustomWizardPage
extends CustomWizardPage
implements IRepositoryListener {
    protected final INode input;
    protected final Collection<TypeDescriptor> validTypes;
    protected final TypeDescriptor[] displayedTypes;

    protected AbstractRepositoryCustomWizardPage(String pageName, INode input, Collection<TypeDescriptor> validTypes, TypeDescriptor ... displayedTypes) {
        super(pageName, false);
        this.input = input;
        this.validTypes = validTypes;
        this.displayedTypes = displayedTypes;
        this.input.getRepository().setSelection((Object)this, null);
        this.input.getRepository().registerSelectionListener((IRepositoryListener)this);
    }

    @Override
    public final void dispose() {
        super.dispose();
        this.input.getRepository().unregisterSelectionListener((IRepositoryListener)this);
    }

    @Override
    public final Point getPageSize() {
        return new Point(300, 500);
    }

    public final IRepository getRepository() {
        return this.input.getRepository();
    }

    @Override
    public boolean isPageComplete() {
        List selectedItems = this.input.getRepository().getSelections();
        int numberOfSelectedItems = selectedItems.size();
        if (numberOfSelectedItems < this.minSelection() || numberOfSelectedItems > this.maxSelection()) {
            return false;
        }
        for (INodeRelation selection : selectedItems) {
            if (this.validTypes == null || this.validTypes.contains(selection.getTarget().getType())) continue;
            return false;
        }
        return true;
    }

    public final void selectionChanged(Object source, IRepository repository) {
        if (this.getWizard() != null) {
            this.getWizard().getContainer().updateButtons();
        }
    }

    protected int maxSelection() {
        return 1;
    }

    protected int minSelection() {
        return 1;
    }

    @Override
    protected abstract boolean performFinish();

    protected abstract void selectResource();

    @Override
    protected final void setInput(INodeRelation input) {
        super.setInput(input);
        this.selectResource();
    }
}

