/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.dialogs;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.node.NodeFactories;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.LayoutUtils;
import com.centreon.studio.client.model.ui.dialogs.CustomWizard;
import com.centreon.studio.client.utils.CollectionsUtils;
import com.centreon.studio.client.utils.SequenceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Monitor;

public class CustomWizardDialog
extends WizardDialog {
    private static Collection<PropertyDescriptor<?>> PROPERTIES_TO_IGNORE = new ArrayList();
    private Collection<INodeRelation> input;
    private INodeRelation copiedInput;

    static {
        PROPERTIES_TO_IGNORE.add(PropertyDescriptors.NEED_REPLACEMENT);
    }

    public static void addPropertiesToIgnore(PropertyDescriptor<?> pd) {
        PROPERTIES_TO_IGNORE.add(pd);
    }

    private static Collection<INodeRelation> getNewRelations(INodeRelation copiedInput, INodeRelation editedInput) {
        List editedRelations = editedInput.getTarget().getRelations(new TypeDescriptor[0]);
        List copiedRelations = copiedInput.getTarget().getRelations(new TypeDescriptor[0]);
        Iterator iterator = editedRelations.iterator();
        while (iterator.hasNext()) {
            if (!copiedRelations.contains(iterator.next())) continue;
            iterator.remove();
        }
        return editedRelations;
    }

    private static void setCommonValues(IObject object, Map<PropertyDescriptor<?>, Collection<Object>> map) {
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>(16);
        for (Map.Entry<PropertyDescriptor<?>, Collection<Object>> entry : map.entrySet()) {
            Object value = null;
            for (Object val : entry.getValue()) {
                if (value == null) {
                    value = val;
                    continue;
                }
                if (value.equals(val)) continue;
                if (entry.getKey().defaulValue == null) break;
                value = entry.getKey().defaulValue;
                break;
            }
            values.add(PropertyValue.unchecked(entry.getKey(), value));
        }
        object.addPropertyValues(values);
    }

    private static void setDimensions(INodeRelation copy, Collection<INodeRelation> input) {
        Pos dim = null;
        for (INodeRelation relation : input) {
            Pos localDim = (Pos)relation.getProperty(PropertyDescriptors.CURRENT_DIMENSION);
            if (dim == null) {
                dim = localDim;
                continue;
            }
            if (dim.equals((Object)localDim)) continue;
            dim = null;
            break;
        }
        if (dim == null) {
            dim = Pos.NULL;
            for (INodeRelation relation : input) {
                Pos localMinDim = LayoutUtils.INSTANCE.getMinDim(relation);
                dim = Pos.create((double)Math.max(dim.x, localMinDim.x), (double)Math.max(dim.y, localMinDim.y));
            }
        }
        copy.addPropertyValue(PropertyDescriptors.DIMENSION, (Object)dim);
        copy.addPropertyValue(PropertyDescriptors.CURRENT_DIMENSION, null);
    }

    private static boolean shouldPropertyByCopied(PropertyDescriptor<?> pd) {
        return !pd.isLocal && !PROPERTIES_TO_IGNORE.contains(pd);
    }

    public CustomWizardDialog(CustomWizard wizard) {
        super(SWTUtils.getDisplay().getActiveShell(), (IWizard)wizard);
    }

    public void apply() {
        INode copiedNode;
        boolean elementNeedReplacing;
        boolean multiple;
        boolean bl = multiple = this.input.size() > 1;
        if (multiple) {
            INodeRelation relation = this.getWizard().getInput();
            Collection relationPropertiesToRemove = this.copiedInput.getPropertyValues().stream().filter(pv -> Objects.equals(pv.getValue(), relation.getProperty(pv.getProperty()))).map(pv -> new PropertyValue(pv.getProperty(), null)).collect(Collectors.toList());
            relation.addPropertyValues(relationPropertiesToRemove);
            Collection propertiesToRemove = this.copiedInput.getTarget().getPropertyValues().stream().filter(pv -> Objects.equals(pv.getValue(), relation.getTarget().getProperty(pv.getProperty()))).map(pv -> new PropertyValue(pv.getProperty(), null)).collect(Collectors.toList());
            relation.getTarget().addPropertyValues(propertiesToRemove);
        }
        if (elementNeedReplacing = ((Boolean)(copiedNode = this.getWizard().getInput().getTarget()).getProperty(PropertyDescriptors.NEED_REPLACEMENT)).booleanValue()) {
            this.replaceElement();
        } else {
            Collection<INodeRelation> wizardRelations = CustomWizardDialog.getNewRelations(this.copiedInput, this.getWizard().getInput());
            for (INodeRelation relation : this.input) {
                INodeUtils.updateProperties((IObject)relation, (Collection)this.getWizard().getInput().getPropertyValues(), (boolean)true, (!multiple ? 1 : 0) != 0, (String[])new String[0]);
                INodeUtils.updateProperties((IObject)relation.getTarget(), (Collection)this.getWizard().getInput().getTarget().getPropertyValues(), (boolean)true, (!multiple ? 1 : 0) != 0, (String[])new String[0]);
                Collection relations = wizardRelations.stream().map(wizardRelation -> INodeUtils.copy((INodeRelation)wizardRelation, (INode)relation.getTarget(), (boolean)true, (boolean)true, (IRepository)relation.getTarget().getRepository(), (PropertyValue[])new PropertyValue[0])).collect(Collectors.toList());
                relation.getTarget().addRelations(relations);
            }
        }
    }

    public Collection<INodeRelation> getInput() {
        return this.input;
    }

    public CustomWizard getWizard() {
        return (CustomWizard)super.getWizard();
    }

    public int open() {
        this.setPageSize(this.getWizard().getPageSize());
        int result = super.open();
        if (result == 0 && this.getWizard().getInput() != null) {
            this.apply();
        }
        return result;
    }

    public void setInput(Collection<INodeRelation> input) {
        this.input = input;
        INodeRelation first = input.iterator().next();
        INodeRelation copy = INodeUtils.copy((INodeRelation)first, (INode)first.getSource(), (boolean)true, (boolean)true, null, (PropertyValue[])new PropertyValue[0]);
        if (input.size() > 1) {
            Map relationMap = CollectionsUtils.createMultiMap((int)1, ArrayList.class);
            Map targetMap = CollectionsUtils.createMultiMap((int)1, ArrayList.class);
            for (INodeRelation relation : input) {
                for (PropertyValue value : relation.getPropertyValues()) {
                    ((Collection)relationMap.get(value.getProperty())).add(value.getValue());
                }
                for (PropertyValue value : relation.getTarget().getPropertyValues()) {
                    ((Collection)targetMap.get(value.getProperty())).add(value.getValue());
                }
            }
            CustomWizardDialog.setCommonValues((IObject)copy, relationMap);
            CustomWizardDialog.setCommonValues((IObject)copy.getTarget(), targetMap);
            CustomWizardDialog.setDimensions(copy, input);
        }
        this.copiedInput = INodeUtils.copy((INodeRelation)copy, (INode)copy.getSource(), (boolean)true, (boolean)true, null, (PropertyValue[])new PropertyValue[0]);
        this.getWizard().setInput(copy);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button backButton;
        super.createButtonsForButtonBar(parent);
        Button finishButton = this.getButton(16);
        finishButton.setData("org.eclipse.swtbot.widget.key", (Object)"finishButton");
        Button cancelButton = this.getButton(1);
        cancelButton.setData("org.eclipse.swtbot.widget.key", (Object)"cancelButton");
        Button nextButton = this.getButton(15);
        if (nextButton != null) {
            nextButton.setData("org.eclipse.swtbot.widget.key", (Object)"nextButton");
        }
        if ((backButton = this.getButton(14)) != null) {
            backButton.setData("org.eclipse.swtbot.widget.key", (Object)"backButton");
        }
    }

    protected Rectangle getConstrainedShellBounds(Rectangle preferredSize) {
        Rectangle result = new Rectangle(preferredSize.x, preferredSize.y, preferredSize.width, preferredSize.height);
        Monitor mon = SWTUtils.getCursorMonitor();
        Rectangle bounds = mon.getClientArea();
        if (result.height > bounds.height) {
            result.height = bounds.height;
        }
        if (result.width > bounds.width) {
            result.width = bounds.width;
        }
        result.x = (bounds.width - preferredSize.width) / 2 + bounds.x;
        result.y = (bounds.height - preferredSize.height) / 2 + bounds.y;
        return result;
    }

    private void replaceElement() {
        INodeRelation copiedRelation = this.getWizard().getInput();
        INode copiedNode = copiedRelation.getTarget();
        INodeRelation originalRelation = this.getInput().stream().findAny().orElse(null);
        INode parent = originalRelation.getSource();
        Collection nodeProperties = copiedNode.getPropertyValues().stream().filter(pv -> CustomWizardDialog.shouldPropertyByCopied(pv.getProperty())).collect(Collectors.toList());
        nodeProperties.add(new PropertyValue(PropertyDescriptors.PREVIOUS_ID, (Object)originalRelation.getTarget().getId()));
        INode newNode = NodeFactories.INSTANCE.create(copiedNode.getType(), SequenceUtils.next(), nodeProperties, copiedNode.getRepository());
        INodeRelation newNodeRelation = NodeRelationFactories.INSTANCE.create(copiedRelation.getType(), SequenceUtils.next(), parent, newNode, copiedRelation.getPropertyValues());
        parent.removeRelation(originalRelation);
        parent.addRelation(newNodeRelation);
    }
}

