/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.dialogs;

import com.centreon.studio.client.commons.jface.validation.form.Form;
import com.centreon.studio.client.commons.jface.validation.form.IForm;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.IImageInterface;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.IPropertiesListener;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyFormatter;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public abstract class CustomWizardPage
extends WizardPage
implements IPropertiesListener,
Runnable {
    private final boolean addScroller;
    private final IForm form;
    private INodeRelation input;
    private Composite parent;
    private Composite composite;

    protected static <T extends IImageInterface> void createDescriptorButton(Composite parent, final IObject input, PropertyDescriptor<T> descriptor, T[] objects) {
        SWTUtils.createLabel((Composite)parent, (String)descriptor.label);
        Composite composite = SWTUtils.createComposite((Composite)parent, (int)(objects.length + 1), (boolean)false);
        composite.setLayoutData((Object)SWTUtils.createGridDataHorizontalFill());
        ArrayList<Button> buttons = new ArrayList<Button>(objects.length);
        PropertyFormatter pf = PropertyFormatter.getPropetyFormatter((Class)descriptor.clazz);
        T[] TArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            Button button = SWTUtils.createButton((Composite)composite, (int)2, (Image)SWTUtils.getImageFromUrl((String)t.getImagePath(), (int)16, (int)16), null, null);
            button.addSelectionListener((SelectionListener)new SelectionAdapter((PropertyDescriptor)descriptor, (IImageInterface)t, buttons, button){
                private final /* synthetic */ PropertyDescriptor val$descriptor;
                private final /* synthetic */ IImageInterface val$t;
                private final /* synthetic */ Collection val$buttons;
                private final /* synthetic */ Button val$button;
                {
                    this.val$descriptor = propertyDescriptor;
                    this.val$t = iImageInterface;
                    this.val$buttons = collection;
                    this.val$button = button;
                }

                public void widgetSelected(SelectionEvent e) {
                    if (input != null) {
                        input.addPropertyValue(this.val$descriptor, (Object)this.val$t);
                        this.val$buttons.stream().forEach(b -> b.setSelection(b.equals(this.val$button)));
                    }
                }
            });
            if (input != null && pf.toString((Object)((IImageInterface)input.getProperty(descriptor))).equals(pf.toString(t))) {
                button.setSelection(true);
            }
            buttons.add(button);
            ++n2;
        }
    }

    protected static <T> Combo createDescriptorCombo(Composite parent, final IObject input, final PropertyDescriptor<T> descriptor, T[] objects) {
        Label label = SWTUtils.createLabel((Composite)parent, (String)descriptor.label);
        final Combo combo = SWTUtils.createCombo((Composite)parent, (int)2056, null, (GridData)SWTUtils.createGridDataHorizontalFill(), null);
        combo.addDisposeListener(e -> label.dispose());
        if (objects != null) {
            PropertyFormatter pf = PropertyFormatter.getPropetyFormatter((Class)descriptor.clazz);
            T[] TArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                T object = TArray[n2];
                String objectLabel = pf.toString(object);
                combo.add(objectLabel);
                combo.setData(objectLabel, object);
                ++n2;
            }
            if (input != null) {
                CustomWizardPage.select(combo, pf.toString(input.getProperty(descriptor)));
            }
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (input != null) {
                    String selection = combo.getText();
                    Object object = combo.getData(selection);
                    input.addPropertyValue(descriptor, object);
                }
            }
        });
        return combo;
    }

    protected static void select(Combo combo, String value) {
        if (combo == null || combo.isDisposed()) {
            return;
        }
        combo.select(0);
        if (StringUtils.isNullEmptyOrBlank((String)value)) {
            return;
        }
        int i = 0;
        while (i < combo.getItemCount()) {
            if (combo.getItem(i).equals(value)) {
                combo.select(i);
            }
            ++i;
        }
    }

    protected CustomWizardPage(String pageName) {
        this(pageName, true);
    }

    protected CustomWizardPage(String pageName, boolean addScroller) {
        super(pageName);
        this.addScroller = addScroller;
        this.form = new Form(false, true);
        this.form.registerValidationTrackingRunnable((Runnable)this);
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.getWizard().getNextPage((IWizardPage)this) != null;
    }

    public final void createControl(Composite parent) {
        this.parent = parent;
        Object sc = this.addScroller ? new ScrolledComposite(parent, 768) : parent;
        Composite childComposite = this.customCreateControl((Composite)sc);
        if (childComposite == null) {
            return;
        }
        this.composite = childComposite;
        Point p = childComposite.computeSize(-1, -1);
        if (sc instanceof ScrolledComposite) {
            this.setControl((Control)sc);
            ((ScrolledComposite)sc).setContent((Control)childComposite);
            ((ScrolledComposite)sc).setExpandHorizontal(true);
            ((ScrolledComposite)sc).setExpandVertical(true);
            ((ScrolledComposite)sc).setMinSize(p);
            sc.setSize(p);
        } else {
            this.setControl((Control)childComposite);
        }
        parent.setSize(p);
    }

    public void dispose() {
        super.dispose();
        if (this.input != null) {
            this.input.unregisterPropertiesListener((IPropertiesListener)this);
            this.input.getTarget().unregisterPropertiesListener((IPropertiesListener)this);
        }
    }

    public abstract Point getPageSize();

    public boolean isPageComplete() {
        return this.form.isValid();
    }

    public void propertiesChanged(IObject object, Collection<PropertyValue> propertyValues) {
    }

    @Override
    public final void run() {
        if (this.getWizard() != null && this.getWizard().getContainer() != null && this.getWizard().getContainer().getCurrentPage() != null) {
            this.getWizard().getContainer().updateButtons();
        }
    }

    protected abstract Composite customCreateControl(Composite var1);

    protected final Composite getComposite() {
        return this.composite;
    }

    protected final IForm getForm() {
        return this.form;
    }

    protected final INodeRelation getInput() {
        return this.input;
    }

    protected abstract boolean performFinish();

    protected final void resizeWizard() {
        Composite sc = (Composite)this.getControl();
        if (this.composite != null) {
            Point p = this.composite.computeSize(-1, -1);
            if (sc instanceof ScrolledComposite) {
                ((ScrolledComposite)sc).setMinSize(p);
                sc.setSize(p);
            }
            this.composite.setSize(p);
            this.parent.layout();
        }
    }

    protected void setInput(INodeRelation input) {
        Assert.isNotNull((Object)input, (String)"input must not be null");
        if (this.input != null) {
            this.input.unregisterPropertiesListener((IPropertiesListener)this);
            this.input.getTarget().unregisterPropertiesListener((IPropertiesListener)this);
        }
        this.input = input;
        this.input.registerPropertiesListener((IPropertiesListener)this);
        this.input.getTarget().registerPropertiesListener((IPropertiesListener)this);
    }
}

