/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.dnd.drop;

import com.centreon.studio.client.model.ui.dnd.drop.INodeDropTargetListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;

public class NodeDropTarget {
    private final DropTarget dropTarget;
    private final Collection<INodeDropTargetListener> dropListeners;

    public NodeDropTarget(Control control, int style) {
        this.dropTarget = new DropTarget(control, style);
        this.dropListeners = new ArrayList<INodeDropTargetListener>(0);
    }

    public void addListener(INodeDropTargetListener listener) {
        this.dropListeners.add(listener);
        this.dropTarget.addDropListener((DropTargetListener)listener);
        Transfer[] transferArray = this.dropTarget.getTransfer();
        int n = transferArray.length;
        int n2 = 0;
        while (n2 < n) {
            Transfer t = transferArray[n2];
            if (t == listener.getSupportedTransfer()) {
                return;
            }
            ++n2;
        }
        Transfer[] result = Arrays.copyOf(this.dropTarget.getTransfer(), this.dropTarget.getTransfer().length + 1);
        result[result.length - 1] = listener.getSupportedTransfer();
        this.dropTarget.setTransfer(result);
    }

    public Collection<INodeDropTargetListener> getListeners() {
        return Collections.unmodifiableCollection(this.dropListeners);
    }
}

