/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.dnd.drop;

import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.edit.PasteNodesAction;
import com.centreon.studio.client.model.ui.dnd.NodeTransfer;
import com.centreon.studio.client.model.ui.dnd.drop.ANodeDropTargetListener;
import java.util.Arrays;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;

public class PasteNodeDropTargetListener
extends ANodeDropTargetListener {
    private final IRepository repository;
    private final PasteNodesAction action;

    public PasteNodeDropTargetListener(IRepository repository, PasteNodesAction action) {
        this.repository = repository;
        this.action = action;
    }

    @Override
    public Transfer getSupportedTransfer() {
        return NodeTransfer.getInstance();
    }

    @Override
    protected void doDragOver(DropTargetEvent event) {
        INodeRelation targetRelation = this.getDropTarget(event);
        if (targetRelation != null) {
            this.repository.setSelection((Object)this, Arrays.asList(targetRelation));
        }
        if (this.action.isEnabled()) {
            event.feedback = 25;
            event.detail = 2;
        }
    }

    @Override
    protected void doDrop(DropTargetEvent event) {
        this.action.run();
    }
}

