/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.properties;

import com.centreon.studio.client.model.ui.properties.IPropertySheetEntry;
import com.centreon.studio.client.model.ui.properties.PropertySheetCategory;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;

public class PropertySheetSorter {
    private final Collator collator;

    public PropertySheetSorter() {
        this(Collator.getInstance());
    }

    public PropertySheetSorter(Collator collator) {
        this.collator = collator;
    }

    public int compare(IPropertySheetEntry entryA, IPropertySheetEntry entryB) {
        return this.getCollator().compare(entryA.getDisplayName(), entryB.getDisplayName());
    }

    public int compareCategories(String categoryA, String categoryB) {
        return this.getCollator().compare(categoryA, categoryB);
    }

    public void sort(IPropertySheetEntry[] entries) {
        Arrays.sort(entries, new Comparator<Object>(){

            @Override
            public int compare(Object a, Object b) {
                return PropertySheetSorter.this.compare((IPropertySheetEntry)a, (IPropertySheetEntry)b);
            }
        });
    }

    protected Collator getCollator() {
        return this.collator;
    }

    void sort(PropertySheetCategory[] categories) {
        Arrays.sort(categories, new Comparator<Object>(){

            @Override
            public int compare(Object a, Object b) {
                return PropertySheetSorter.this.compareCategories(((PropertySheetCategory)a).getCategoryName(), ((PropertySheetCategory)b).getCategoryName());
            }
        });
    }
}

