/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.properties;

import com.centreon.studio.client.model.ui.properties.ICellEditorActivationListener;
import com.centreon.studio.client.model.ui.properties.IPropertySheetEntry;
import com.centreon.studio.client.model.ui.properties.IPropertySheetEntryListener;
import com.centreon.studio.client.model.ui.properties.PropertySheetCategory;
import com.centreon.studio.client.model.ui.properties.PropertySheetEntry;
import com.centreon.studio.client.model.ui.properties.PropertySheetSorter;
import com.centreon.studio.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class PropertySheetViewer
extends Viewer {
    private static final String[] COLUMN_LABELS = new String[]{"Property", "Value"};
    private static final String FILTER_ID_EXPERT = "org.eclipse.ui.views.properties.expert";
    private static final String MISCELLANEOUS_CATEGORY_NAME = "Misc";
    private static final int COLUMN_TO_EDIT = 1;
    private Object[] input;
    private IPropertySheetEntry rootEntry;
    private PropertySheetCategory[] categories;
    private final Tree tree;
    private final Map<Object, TreeItem> entryToItemMap = new HashMap<Object, TreeItem>();
    private final TreeEditor treeEditor;
    private CellEditor cellEditor;
    private IPropertySheetEntryListener entryListener;
    private ICellEditorListener editorListener;
    private boolean isShowingCategories = true;
    private boolean isShowingExpertProperties = false;
    private IStatusLineManager statusLineManager;
    private final ListenerList<ICellEditorActivationListener> activationListeners = new ListenerList();
    private PropertySheetSorter sorter = new PropertySheetSorter();
    private final MenuItem menuItem;

    private static TreeItem[] getChildItems(Widget widget) {
        if (widget instanceof Tree) {
            return ((Tree)widget).getItems();
        }
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getItems();
        }
        return new TreeItem[0];
    }

    public PropertySheetViewer(Composite parent) {
        this.tree = new Tree(parent, 98308);
        this.tree.setLinesVisible(true);
        this.tree.setHeaderVisible(true);
        Menu menu = new Menu((Control)this.tree);
        this.menuItem = new MenuItem(menu, 0);
        this.menuItem.setText("Copy");
        this.menuItem.setAccelerator(SWT.MOD1 | 0x43);
        this.menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertySheetViewer.this.copySelection();
            }
        });
        menu.setDefaultItem(this.menuItem);
        this.tree.setMenu(menu);
        this.addColumns();
        this.hookControl();
        this.treeEditor = new TreeEditor(this.tree);
        this.createEntryListener();
        this.createEditorListener();
    }

    public CellEditor getActiveCellEditor() {
        return this.cellEditor;
    }

    public Control getControl() {
        return this.tree;
    }

    public Object getInput() {
        return this.input;
    }

    public IPropertySheetEntry getRootEntry() {
        return this.rootEntry;
    }

    public ISelection getSelection() {
        if (this.tree.getSelectionCount() == 0) {
            return StructuredSelection.EMPTY;
        }
        TreeItem[] sel = this.tree.getSelection();
        ArrayList<Object> entries = new ArrayList<Object>(sel.length);
        TreeItem[] treeItemArray = sel;
        int n = sel.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            Object data = ti.getData();
            if (data instanceof IPropertySheetEntry) {
                entries.add(data);
            }
            ++n2;
        }
        return new StructuredSelection(entries);
    }

    public void refresh() {
        if (this.rootEntry != null) {
            this.updateChildrenOf(this.rootEntry, (Widget)this.tree);
        }
    }

    public void resetProperties() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Iterator itr = selection.iterator();
        while (itr.hasNext()) {
            ((IPropertySheetEntry)itr.next()).resetPropertyValue();
        }
    }

    public void setInput(Object newInput) {
        this.applyEditorValue();
        this.deactivateCellEditor();
        this.input = (Object[])newInput;
        if (this.input == null) {
            this.input = new Object[0];
        }
        if (this.rootEntry != null) {
            this.rootEntry.setValues(this.input);
            this.updateChildrenOf(this.rootEntry, (Widget)this.tree);
        }
        Rectangle area = this.tree.getClientArea();
        this.tree.getColumns()[0].pack();
        this.tree.getColumns()[1].setWidth(area.width - this.tree.getColumns()[0].getWidth() - 20);
        this.updateStatusLine(null);
    }

    public void setRootEntry(IPropertySheetEntry root) {
        if (this.rootEntry != null) {
            this.rootEntry.removePropertySheetEntryListener(this.entryListener);
        }
        this.rootEntry = root;
        this.tree.setData((Object)this.rootEntry);
        this.rootEntry.addPropertySheetEntryListener(this.entryListener);
        this.setInput(this.input);
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void setSorter(PropertySheetSorter sorter) {
        this.sorter = sorter;
        if (this.sorter == null) {
            this.sorter = new PropertySheetSorter();
        }
    }

    public void setStatusLineManager(IStatusLineManager manager) {
        this.statusLineManager = manager;
    }

    protected void updateStatusLine(Widget item) {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (item != null) {
            if (item.getData() instanceof PropertySheetEntry) {
                PropertySheetEntry psEntry = (PropertySheetEntry)item.getData();
                String desc = psEntry.getDescription();
                if (desc != null && desc.length() > 0) {
                    this.setMessage(psEntry.getDescription());
                } else {
                    this.setMessage(psEntry.getDisplayName());
                }
            } else if (item.getData() instanceof PropertySheetCategory) {
                PropertySheetCategory psCat = (PropertySheetCategory)item.getData();
                this.setMessage(psCat.getCategoryName());
            }
        }
    }

    void addActivationListener(ICellEditorActivationListener listener) {
        this.activationListeners.add((Object)listener);
    }

    void deactivateCellEditor() {
        this.treeEditor.setEditor(null, null, 1);
        if (this.cellEditor != null) {
            this.cellEditor.deactivate();
            this.fireCellEditorDeactivated(this.cellEditor);
            this.cellEditor.removeListener(this.editorListener);
            this.cellEditor = null;
        }
        this.setErrorMessage(null);
    }

    void hideCategories() {
        this.isShowingCategories = false;
        this.categories = null;
        this.refresh();
    }

    void hideExpert() {
        this.isShowingExpertProperties = false;
        this.refresh();
    }

    void removeActivationListener(ICellEditorActivationListener listener) {
        this.activationListeners.remove((Object)listener);
    }

    void showCategories() {
        this.isShowingCategories = true;
        this.refresh();
    }

    void showExpert() {
        this.isShowingExpertProperties = true;
        this.refresh();
    }

    private void activateCellEditor(TreeItem item) {
        this.tree.showSelection();
        IPropertySheetEntry activeEntry = (IPropertySheetEntry)item.getData();
        this.cellEditor = activeEntry.getEditor((Composite)this.tree);
        if (this.cellEditor == null) {
            return;
        }
        this.cellEditor.activate();
        Control control = this.cellEditor.getControl();
        if (control == null) {
            this.cellEditor.deactivate();
            this.cellEditor = null;
            return;
        }
        this.cellEditor.addListener(this.editorListener);
        CellEditor.LayoutData layout = this.cellEditor.getLayoutData();
        this.treeEditor.horizontalAlignment = layout.horizontalAlignment;
        this.treeEditor.grabHorizontal = layout.grabHorizontal;
        this.treeEditor.minimumWidth = layout.minimumWidth;
        this.treeEditor.setEditor(control, item, 1);
        this.setErrorMessage(this.cellEditor.getErrorMessage());
        this.cellEditor.setFocus();
        this.fireCellEditorActivated(this.cellEditor);
    }

    private void addColumns() {
        String[] stringArray = COLUMN_LABELS;
        int n = COLUMN_LABELS.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            TreeColumn column = new TreeColumn(this.tree, 0);
            column.setText(string);
            ++n2;
        }
    }

    private void applyEditorValue() {
        TreeItem treeItem = this.treeEditor.getItem();
        if (treeItem == null || treeItem.isDisposed()) {
            return;
        }
        IPropertySheetEntry entry = (IPropertySheetEntry)treeItem.getData();
        entry.applyEditorValue();
    }

    private void copySelection() {
        TreeItem[] items = this.tree.getSelection();
        if (items.length == 1) {
            TreeItem item = items[0];
            String itemValue = item.getText(1);
            if (StringUtils.isNullEmptyOrBlank((String)itemValue)) {
                return;
            }
            Display display = Display.getCurrent();
            Clipboard clipboard = new Clipboard(display);
            clipboard.setContents(new Object[]{itemValue}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }
    }

    private void createChildren(Widget widget) {
        Object node;
        List<?> children;
        TreeItem[] childItems = PropertySheetViewer.getChildItems(widget);
        if (childItems.length > 0) {
            Object data = childItems[0].getData();
            if (data != null) {
                return;
            }
            childItems[0].dispose();
        }
        if ((children = this.getChildren(node = widget.getData())).isEmpty()) {
            return;
        }
        int i = 0;
        while (i < children.size()) {
            this.createItem(children.get(i), widget, i);
            ++i;
        }
    }

    private void createEditorListener() {
        this.editorListener = new ICellEditorListener(){

            public void applyEditorValue() {
            }

            public void cancelEditor() {
                PropertySheetViewer.this.deactivateCellEditor();
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }
        };
    }

    private void createEntryListener() {
        this.entryListener = new IPropertySheetEntryListener(){

            @Override
            public void childEntriesChanged(IPropertySheetEntry entry) {
                if (entry == PropertySheetViewer.this.rootEntry) {
                    PropertySheetViewer.this.updateChildrenOf(entry, (Widget)PropertySheetViewer.this.tree);
                } else {
                    TreeItem item = PropertySheetViewer.this.findItem(entry);
                    if (item != null) {
                        PropertySheetViewer.this.updateChildrenOf(entry, (Widget)item);
                    }
                }
            }

            @Override
            public void errorMessageChanged(IPropertySheetEntry entry) {
                PropertySheetViewer.this.setErrorMessage(entry.getErrorText());
            }

            @Override
            public void valueChanged(IPropertySheetEntry entry) {
                TreeItem item = PropertySheetViewer.this.findItem(entry);
                if (item != null) {
                    PropertySheetViewer.this.updateEntry(entry, item);
                }
            }
        };
    }

    private void createItem(Object node, Widget parent, int index) {
        TreeItem item = parent instanceof TreeItem ? new TreeItem((TreeItem)parent, 0, index) : new TreeItem((Tree)parent, 0, index);
        item.setData(node);
        this.entryToItemMap.put(node, item);
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Object possibleEntry = e.widget.getData();
                if (possibleEntry != null) {
                    PropertySheetViewer.this.entryToItemMap.remove(possibleEntry);
                }
            }
        });
        if (node instanceof IPropertySheetEntry) {
            ((IPropertySheetEntry)node).addPropertySheetEntryListener(this.entryListener);
        }
        if (node instanceof IPropertySheetEntry) {
            this.updateEntry((IPropertySheetEntry)node, item);
        } else {
            this.updateCategory((PropertySheetCategory)node, item);
        }
    }

    private void entrySelectionChanged() {
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    private TreeItem findItem(IPropertySheetEntry entry) {
        TreeItem[] items;
        TreeItem[] treeItemArray = items = this.tree.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            TreeItem findItem = this.findItem(entry, item);
            if (findItem != null) {
                return findItem;
            }
            ++n2;
        }
        return null;
    }

    private TreeItem findItem(IPropertySheetEntry entry, TreeItem item) {
        TreeItem[] items;
        TreeItem mapItem = this.entryToItemMap.get(entry);
        if (mapItem != null) {
            return mapItem;
        }
        if (entry == item.getData()) {
            return item;
        }
        TreeItem[] treeItemArray = items = item.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem childItem = treeItemArray[n2];
            TreeItem findItem = this.findItem(entry, childItem);
            if (findItem != null) {
                return findItem;
            }
            ++n2;
        }
        return null;
    }

    private void fireCellEditorActivated(CellEditor activatedCellEditor) {
        Object[] listeners;
        Object[] objectArray = listeners = this.activationListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ICellEditorActivationListener)listener).cellEditorActivated(activatedCellEditor);
            ++n2;
        }
    }

    private void fireCellEditorDeactivated(CellEditor activatedCellEditor) {
        Object[] listeners;
        Object[] objectArray = listeners = this.activationListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ICellEditorActivationListener)listener).cellEditorDeactivated(activatedCellEditor);
            ++n2;
        }
    }

    private List<?> getChildren(IPropertySheetEntry entry) {
        if (entry == this.rootEntry && this.isShowingCategories && (this.categories.length > 1 || this.categories.length == 1 && !this.categories[0].getCategoryName().equals(MISCELLANEOUS_CATEGORY_NAME))) {
            return Arrays.asList(this.categories);
        }
        return this.getSortedEntries(this.getFilteredEntries(entry.getChildEntries()));
    }

    private List<?> getChildren(Object node) {
        IPropertySheetEntry entry = null;
        PropertySheetCategory category = null;
        if (node instanceof IPropertySheetEntry) {
            entry = (IPropertySheetEntry)node;
        } else {
            category = (PropertySheetCategory)node;
        }
        List<?> children = category == null ? this.getChildren(entry) : this.getChildren(category);
        return children;
    }

    private List<?> getChildren(PropertySheetCategory category) {
        return this.getSortedEntries(this.getFilteredEntries(category.getChildEntries()));
    }

    private List<IPropertySheetEntry> getFilteredEntries(IPropertySheetEntry[] entries) {
        if (this.isShowingExpertProperties) {
            return Arrays.asList(entries);
        }
        ArrayList<IPropertySheetEntry> filteredEntries = new ArrayList<IPropertySheetEntry>(entries.length);
        IPropertySheetEntry[] iPropertySheetEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertySheetEntry entry = iPropertySheetEntryArray[n2];
            if (entry != null) {
                String[] filters = entry.getFilters();
                boolean expert = false;
                if (filters != null) {
                    String[] stringArray = filters;
                    int n3 = filters.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String filter = stringArray[n4];
                        if (filter.equals(FILTER_ID_EXPERT)) {
                            expert = true;
                            break;
                        }
                        ++n4;
                    }
                }
                if (!expert) {
                    filteredEntries.add(entry);
                }
            }
            ++n2;
        }
        return filteredEntries;
    }

    private List<?> getSortedEntries(List<IPropertySheetEntry> unsortedEntries) {
        IPropertySheetEntry[] propertySheetEntries = unsortedEntries.toArray(new IPropertySheetEntry[unsortedEntries.size()]);
        this.sorter.sort(propertySheetEntries);
        return Arrays.asList(propertySheetEntries);
    }

    private void handleSelect(TreeItem selection) {
        if (this.cellEditor != null) {
            this.applyEditorValue();
            this.deactivateCellEditor();
        }
        if (selection == null) {
            this.setMessage(null);
            this.setErrorMessage(null);
        } else {
            Object object = selection.getData();
            if (object instanceof IPropertySheetEntry) {
                IPropertySheetEntry activeEntry = (IPropertySheetEntry)object;
                this.setMessage(activeEntry.getDescription());
                this.activateCellEditor(selection);
            }
        }
        this.entrySelectionChanged();
    }

    private void handleTreeCollapse() {
        if (this.cellEditor != null) {
            this.applyEditorValue();
            this.deactivateCellEditor();
        }
    }

    private void handleTreeExpand(TreeEvent event) {
        this.createChildren(event.item);
    }

    private void hookControl() {
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.item instanceof TreeItem) {
                    PropertySheetViewer.this.handleSelect((TreeItem)e.item);
                }
            }

            public void widgetSelected(SelectionEvent e) {
                if (PropertySheetViewer.this.cellEditor == null || !PropertySheetViewer.this.cellEditor.isActivated()) {
                    PropertySheetViewer.this.updateStatusLine(e.item);
                }
            }
        });
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                TreeItem item = PropertySheetViewer.this.tree.getItem(pt);
                if (item != null) {
                    PropertySheetViewer.this.handleSelect(item);
                }
                if (PropertySheetViewer.this.menuItem != null) {
                    PropertySheetViewer.this.menuItem.setEnabled(item != null && !StringUtils.isNullEmptyOrBlank((String)item.getText(1)));
                }
            }
        });
        this.tree.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent event) {
                PropertySheetViewer.this.handleTreeCollapse();
            }

            public void treeExpanded(TreeEvent event) {
                PropertySheetViewer.this.handleTreeExpand(event);
            }
        });
        this.tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & SWT.MOD1) == SWT.MOD1 && e.keyCode == 99) {
                    PropertySheetViewer.this.copySelection();
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    PropertySheetViewer.this.deactivateCellEditor();
                } else if (e.keyCode == 0x100000E) {
                    PropertySheetViewer.this.setInput(PropertySheetViewer.this.getInput());
                }
            }
        });
    }

    private void removeItem(TreeItem item) {
        Object data = item.getData();
        if (data instanceof IPropertySheetEntry) {
            ((IPropertySheetEntry)data).removePropertySheetEntryListener(this.entryListener);
        }
        item.setData(null);
        this.entryToItemMap.remove(data);
        item.dispose();
    }

    private void setErrorMessage(String errorMessage) {
        if (this.statusLineManager != null) {
            this.statusLineManager.setErrorMessage(errorMessage);
        }
    }

    private void setMessage(String message) {
        if (this.statusLineManager != null) {
            this.statusLineManager.setMessage(message);
        }
    }

    private void updateCategories() {
        List<IPropertySheetEntry> childEntries;
        if (this.categories == null) {
            this.categories = new PropertySheetCategory[0];
        }
        if ((childEntries = this.getFilteredEntries(this.rootEntry.getChildEntries())).isEmpty()) {
            this.categories = new PropertySheetCategory[0];
            return;
        }
        HashMap<String, PropertySheetCategory> categoryCache = new HashMap<String, PropertySheetCategory>(this.categories.length * 2 + 1);
        PropertySheetCategory[] propertySheetCategoryArray = this.categories;
        int n = this.categories.length;
        int n2 = 0;
        while (n2 < n) {
            PropertySheetCategory categorie = propertySheetCategoryArray[n2];
            categorie.removeAllEntries();
            categoryCache.put(categorie.getCategoryName(), categorie);
            ++n2;
        }
        ArrayList<PropertySheetCategory> categoriesToRemove = new ArrayList<PropertySheetCategory>(Arrays.asList(this.categories));
        PropertySheetCategory misc = (PropertySheetCategory)categoryCache.get(MISCELLANEOUS_CATEGORY_NAME);
        if (misc == null) {
            misc = new PropertySheetCategory(MISCELLANEOUS_CATEGORY_NAME);
        }
        boolean addMisc = false;
        int i = 0;
        while (i < childEntries.size()) {
            IPropertySheetEntry childEntry = childEntries.get(i);
            String categoryName = childEntry.getCategory();
            if (categoryName == null) {
                misc.addEntry(childEntry);
                addMisc = true;
                categoriesToRemove.remove(misc);
            } else {
                PropertySheetCategory category = (PropertySheetCategory)categoryCache.get(categoryName);
                if (category == null) {
                    category = new PropertySheetCategory(categoryName);
                    categoryCache.put(categoryName, category);
                } else {
                    categoriesToRemove.remove(category);
                }
                category.addEntry(childEntry);
            }
            ++i;
        }
        if (addMisc) {
            categoryCache.put(MISCELLANEOUS_CATEGORY_NAME, misc);
        }
        ArrayList<PropertySheetCategory> categoryList = new ArrayList<PropertySheetCategory>();
        HashSet<String> seen = new HashSet<String>(childEntries.size());
        int i2 = 0;
        while (i2 < childEntries.size()) {
            IPropertySheetEntry childEntry = childEntries.get(i2);
            String categoryName = childEntry.getCategory();
            if (categoryName != null && !seen.contains(categoryName)) {
                seen.add(categoryName);
                PropertySheetCategory category = (PropertySheetCategory)categoryCache.get(categoryName);
                if (category != null) {
                    categoryList.add(category);
                }
            }
            ++i2;
        }
        if (addMisc && !seen.contains(MISCELLANEOUS_CATEGORY_NAME)) {
            categoryList.add(misc);
        }
        PropertySheetCategory[] categoryArray = categoryList.toArray(new PropertySheetCategory[categoryList.size()]);
        this.sorter.sort(categoryArray);
        this.categories = categoryArray;
    }

    private void updateCategory(PropertySheetCategory category, TreeItem item) {
        item.setData((Object)category);
        this.entryToItemMap.put(category, item);
        item.setText(0, category.getCategoryName());
        item.setText(1, "");
        if (category.getAutoExpand()) {
            this.createChildren((Widget)item);
            item.setExpanded(true);
            category.setAutoExpand(false);
        } else {
            this.updatePlus(category, item);
        }
    }

    private void updateChildrenOf(Object node, Widget widget) {
        Object el;
        IPropertySheetEntry entry = null;
        PropertySheetCategory category = null;
        if (node instanceof IPropertySheetEntry) {
            entry = (IPropertySheetEntry)node;
        } else {
            category = (PropertySheetCategory)node;
        }
        TreeItem[] childItems = PropertySheetViewer.getChildItems(widget);
        TreeItem item = null;
        if (widget instanceof TreeItem) {
            item = (TreeItem)widget;
        }
        if (item != null && !item.getExpanded()) {
            TreeItem[] treeItemArray = childItems;
            int n = childItems.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem childItem = treeItemArray[n2];
                if (childItem.getData() != null) {
                    this.removeItem(childItem);
                }
                ++n2;
            }
            if ((category != null || entry != null && entry.hasChildEntries()) && (childItems = PropertySheetViewer.getChildItems(widget)).length == 0) {
                new TreeItem(item, 0);
            }
            return;
        }
        if (node == this.rootEntry && this.isShowingCategories) {
            this.updateCategories();
        }
        List<?> children = this.getChildren(node);
        HashSet<Object> set = new HashSet<Object>(childItems.length * 2 + 1);
        TreeItem[] treeItemArray = childItems;
        int n = childItems.length;
        int n3 = 0;
        while (n3 < n) {
            TreeItem childItem = treeItemArray[n3];
            Object data = childItem.getData();
            if (data != null) {
                Object e = data;
                int ix = children.indexOf(e);
                if (ix < 0) {
                    this.removeItem(childItem);
                } else {
                    set.add(e);
                }
            } else {
                childItem.dispose();
            }
            ++n3;
        }
        int oldCnt = -1;
        if (widget == this.tree) {
            oldCnt = this.tree.getItemCount();
        }
        int newSize = children.size();
        int i = 0;
        while (i < newSize) {
            el = children.get(i);
            if (!set.contains(el)) {
                this.createItem(el, widget, i);
            }
            ++i;
        }
        if (widget == this.tree && oldCnt == 0 && this.tree.getItemCount() == 1) {
            this.tree.setRedraw(false);
            this.tree.setRedraw(true);
        }
        childItems = PropertySheetViewer.getChildItems(widget);
        i = 0;
        while (i < newSize) {
            el = children.get(i);
            if (el instanceof IPropertySheetEntry) {
                this.updateEntry((IPropertySheetEntry)el, childItems[i]);
            } else {
                this.updateCategory((PropertySheetCategory)el, childItems[i]);
                this.updateChildrenOf(el, (Widget)childItems[i]);
            }
            ++i;
        }
        this.entrySelectionChanged();
    }

    private void updateEntry(IPropertySheetEntry entry, TreeItem item) {
        item.setData((Object)entry);
        this.entryToItemMap.put(entry, item);
        item.setText(0, entry.getDisplayName());
        item.setText(1, entry.getValueAsString());
        Image image = entry.getImage();
        if (item.getImage(1) != image) {
            item.setImage(1, image);
        }
        if (entry instanceof PropertySheetEntry) {
            PropertySheetEntry entry2 = (PropertySheetEntry)entry;
            Color color = entry2.getForeground();
            if (item.getForeground() != color) {
                item.setForeground(color);
            }
            color = entry2.getBackground();
            if (item.getBackground() != color) {
                item.setBackground(1, color);
            }
            Font font = entry2.getFont();
            if (item.getFont() != font) {
                item.setFont(font);
            }
        }
        this.updatePlus(entry, item);
    }

    private void updatePlus(Object node, TreeItem item) {
        IPropertySheetEntry entry = null;
        PropertySheetCategory category = null;
        if (node instanceof IPropertySheetEntry) {
            entry = (IPropertySheetEntry)node;
        } else {
            category = (PropertySheetCategory)node;
        }
        boolean hasPlus = item.getItemCount() > 0;
        boolean needsPlus = category != null || entry != null && entry.hasChildEntries();
        boolean removeAll = false;
        boolean addDummy = false;
        if (hasPlus != needsPlus) {
            if (needsPlus) {
                addDummy = true;
            } else {
                removeAll = true;
            }
        }
        if (removeAll) {
            TreeItem[] items;
            TreeItem[] treeItemArray = items = item.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item2 = treeItemArray[n2];
                this.removeItem(item2);
                ++n2;
            }
        }
        if (addDummy) {
            new TreeItem(item, 0);
        }
    }
}

