/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.tooltips;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.ui.tooltips.ATooltip;
import com.centreon.studio.client.model.ui.tooltips.TooltipFactories;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public enum TooltipManager {
    INSTANCE;

    private Shell tooltipShell;
    private ATooltip tooltip;
    private boolean enabled = false;

    private static Point computeTooltipLocation(Point tooltipSize) {
        Display display = SWTUtils.getDisplay();
        Point tooltipLocation = display.getCursorLocation();
        Rectangle bounds = display.getBounds();
        if (tooltipLocation.x + tooltipSize.x > bounds.width + bounds.x) {
            tooltipLocation.x -= tooltipSize.x;
        }
        if (tooltipLocation.x < bounds.x) {
            tooltipLocation.x = bounds.x;
        }
        if (tooltipLocation.y + tooltipSize.y > bounds.height + bounds.y) {
            tooltipLocation.y -= tooltipSize.y;
        }
        if (tooltipLocation.y < bounds.y) {
            tooltipLocation.y = bounds.y;
        }
        return tooltipLocation;
    }

    public void displayTooltip(INodeRelation relation, IEclipseContext context) {
        if (!this.enabled) {
            return;
        }
        this.tooltip = TooltipFactories.INSTANCE.create(relation, context);
        if (this.tooltip == null) {
            return;
        }
        this.tooltipShell = SWTUtils.createShellTool((int)1, (boolean)false, (boolean)false, (boolean)true, (int)1, (boolean)true);
        this.tooltip.createContent((Composite)this.tooltipShell);
        this.updateTooltipLocation();
        this.tooltipShell.open();
        this.tooltipShell.setActive();
    }

    public void enableTooltips(boolean enabled) {
        this.enabled = enabled;
        this.removeTooltip();
    }

    public boolean isTooltipDisplayed() {
        return this.tooltipShell != null && !this.tooltipShell.isDisposed();
    }

    public void removeTooltip() {
        if (this.isTooltipDisplayed()) {
            this.tooltipShell.dispose();
            this.tooltipShell = null;
        }
    }

    public void updateTooltipLocation() {
        if (this.tooltipShell != null && !this.tooltipShell.isDisposed() && this.tooltip != null) {
            Point tooltipSize = this.tooltip.getSize();
            Point tooltipLocation = TooltipManager.computeTooltipLocation(tooltipSize);
            this.tooltipShell.setBounds(tooltipLocation.x + 15, tooltipLocation.y + 15, tooltipSize.x, tooltipSize.y);
        }
    }
}

