/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.zest;

import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.zest.NodeRelationLayoutEntity;
import com.centreon.studio.client.zest.NodeRelationLayoutRelationship;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class ZestModel {
    private final List<NodeRelationLayoutRelationship> relationships;
    private final List<NodeRelationLayoutEntity> entities;

    public ZestModel(Collection<INodeRelation> relations) {
        HashMap<INode, NodeRelationLayoutEntity> entitiesMap = new HashMap<INode, NodeRelationLayoutEntity>(relations.size());
        this.relationships = new ArrayList<NodeRelationLayoutRelationship>(relations.size() - 1);
        this.entities = new ArrayList<NodeRelationLayoutEntity>(relations.size());
        for (INodeRelation relation : relations) {
            NodeRelationLayoutEntity entity = new NodeRelationLayoutEntity(relation);
            entitiesMap.put(relation.getTarget(), entity);
            this.entities.add(entity);
        }
        for (INodeRelation relation : relations) {
            NodeRelationLayoutEntity source = (NodeRelationLayoutEntity)entitiesMap.get(relation.getSource());
            if (source == null) continue;
            NodeRelationLayoutEntity target = (NodeRelationLayoutEntity)entitiesMap.get(relation.getTarget());
            this.relationships.add(new NodeRelationLayoutRelationship(relation, source, target));
        }
    }

    public NodeRelationLayoutEntity[] getEntities() {
        return this.entities.toArray(new NodeRelationLayoutEntity[this.entities.size()]);
    }

    public NodeRelationLayoutRelationship[] getRelationships() {
        return this.relationships.toArray(new NodeRelationLayoutRelationship[this.relationships.size()]);
    }

    protected void apply() {
        for (NodeRelationLayoutEntity entity : this.entities) {
            entity.applyToModel();
        }
        for (NodeRelationLayoutRelationship relationship : this.relationships) {
            relationship.applyToModel();
        }
    }
}

