/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.importmap3;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.model.decoration.repository.RepositoryDecorator;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeRelationListener;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.navigation.OpenNodeAction;
import com.centreon.studio.map.client.gates.model.GatePropertyDescriptors;
import com.centreon.studio.map.client.importmap3.RootElementListener;
import com.centreon.studio.map.client.importmap3.transformer.Transformer;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class GateListener
implements INodeRelationListener {
    private final Long gateId;
    private final IEclipseContext context;
    private final Transformer transformer;
    private final IRepository gateRepository;
    private final RepositoryDecorator elementRepository;
    private final BrokerEventManager eventManager;

    public GateListener(IEclipseContext context, IRepository gateRepository, RepositoryDecorator elementRepository, Long gateId, Transformer transformer) {
        this.gateId = gateId;
        this.context = context;
        this.transformer = transformer;
        this.gateRepository = gateRepository;
        this.elementRepository = elementRepository;
        this.eventManager = (BrokerEventManager)ContextInjectionFactory.make(BrokerEventManager.class, (IEclipseContext)context);
    }

    public void relationsAdded(INode node, Collection<INodeRelation> relations) {
        this.eventManager.sync((StudioEvent)LogEvent.trace(GateListener.class, (String)("Relation added for node:" + node + "\nAnd relations: " + relations), (Object[])new Object[0]));
        for (INodeRelation relation : relations) {
            if (!this.gateId.equals(relation.getTarget().getProperty(PropertyDescriptors.PREVIOUS_ID))) continue;
            this.eventManager.sync((StudioEvent)LogEvent.trace(GateListener.class, (String)"Create RootElementListener, and register it to ElementRepository.", (Object[])new Object[0]));
            RootElementListener rootElementListener = new RootElementListener(this.context, this.transformer, (Long)relation.getTarget().getProperty(GatePropertyDescriptors.TARGET_ID));
            this.elementRepository.registerRelationsListener((INodeRelationListener)rootElementListener);
            SWTUtils.getDisplay().syncExec(() -> {
                this.transformer.progressMonitor.worked(1);
                this.transformer.progressMonitor.setTaskName("Open gate");
                this.eventManager.sync((StudioEvent)LogEvent.trace(GateListener.class, (String)("Opening the gate: " + relation), (Object[])new Object[0]));
                this.gateRepository.setSelection((Object)this, Arrays.asList(relation));
                new OpenNodeAction(this.gateRepository, this.context).run();
                this.transformer.progressMonitor.setTaskName("Waiting for gate to be received");
            });
            this.gateRepository.unregisterRelationsListener((INodeRelationListener)this);
            break;
        }
    }

    public void relationsRemoved(INode node, Collection<INodeRelation> relations) {
    }
}

