/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.importmap3;

import com.centreon.studio.client.acl.ACLUser;
import com.centreon.studio.client.commons.ContextUtils;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardPage;
import com.centreon.studio.map.client.importmap3.Importer;
import com.centreon.studio.map.client.importmap3.extractor.Extractor;
import com.centreon.studio.map.client.importmap3.extractor.model.map3.Container;
import com.centreon.studio.map.client.importmap3.messages.ImportMap3Messages;
import com.centreon.studio.map.client.importmap3.transformer.Transformer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ImportMap3WizardPage
extends CustomWizardPage {
    private final IEclipseContext context;
    private final BrokerEventManager eventManager;
    private final Set<Button> viewSet = new HashSet<Button>(10);
    private Long gateToImport;

    protected ImportMap3WizardPage(IEclipseContext context) {
        super(ImportMap3Messages.importFromMap3);
        this.setTitle(ImportMap3Messages.importFromMap3);
        this.context = context;
        Transformer.resetTaskDoneCounter();
        this.eventManager = (BrokerEventManager)ContextInjectionFactory.make(BrokerEventManager.class, (IEclipseContext)context);
    }

    public Composite customCreateControl(Composite parent) {
        Composite composite = SWTUtils.createComposite((Composite)parent, (int)1, (boolean)false, (int)5, (int)5);
        SWTUtils.createLabel((Composite)composite, (String)ImportMap3Messages.chooseViews, (int)1, (int)0x1000000, (int)-1, (int)-1);
        SWTUtils.createSpanner((Composite)composite, (int)1, (int)1);
        try {
            ACLUser user = (ACLUser)ContextUtils.getTopContext((IEclipseContext)this.context).get(ACLUser.class);
            Extractor.authenticate(user);
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
            return null;
        }
        Extractor extractor = new Extractor(this.eventManager);
        extractor.requestViewList();
        Map<Long, Container> viewsMap = extractor.getViews();
        ArrayList<Container> viewsList = new ArrayList<Container>(viewsMap.values());
        Collections.sort(viewsList, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Button button : ImportMap3WizardPage.this.viewSet) {
                    button.setSelection(false);
                }
                ((Button)e.widget).setSelection(true);
            }
        };
        for (Container view : viewsList) {
            Button check = SWTUtils.createButton((Composite)composite, (int)32, (String)view.getName(), (GridData)SWTUtils.createGridData((int)1, (int)0x1000000, (int)-1, (int)-1), (SelectionListener)listener);
            check.setData((Object)view.getId());
            this.viewSet.add(check);
        }
        return composite;
    }

    public Point getPageSize() {
        return new Point(450, 300);
    }

    protected boolean performFinish() {
        try {
            this.getContainer().run(true, true, monitor -> {
                for (Button button : this.viewSet) {
                    SWTUtils.getDisplay().syncExec(() -> {
                        if (button.getSelection()) {
                            this.gateToImport = (Long)button.getData();
                        }
                    });
                }
                this.eventManager.sync((StudioEvent)LogEvent.trace(ImportMap3WizardPage.class, (String)("Start of map3 import on gate: " + this.gateToImport), (Object[])new Object[0]));
                Importer importer = new Importer(this.context, this.gateToImport, monitor);
                new Thread(importer).start();
                Importer importer2 = importer;
                synchronized (importer2) {
                    while (!importer.isFinished()) {
                        importer.wait();
                    }
                }
                this.eventManager.sync((StudioEvent)LogEvent.trace(ImportMap3WizardPage.class, (String)("End of map3 import on gate " + this.gateToImport), (Object[])new Object[0]));
                Transformer.sendTaskDonePopUp(String.valueOf(this.gateToImport), this.eventManager);
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

