/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.importmap3;

import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.events.popup.PopUpEvent;
import com.centreon.studio.map.client.importmap3.ImportMap3Exception;
import com.centreon.studio.map.client.importmap3.extractor.Extractor;
import com.centreon.studio.map.client.importmap3.messages.ImportMap3Messages;
import com.centreon.studio.map.client.importmap3.transformer.Transformer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class Importer
implements Runnable {
    private final Long gateToImport;
    private final IEclipseContext context;
    private final BrokerEventManager eventManager;
    private final IProgressMonitor progressMonitor;
    private boolean finished = false;

    public Importer(IEclipseContext context, Long gateToImport, IProgressMonitor progressMonitor) {
        this.gateToImport = gateToImport;
        this.context = context;
        this.progressMonitor = progressMonitor;
        this.eventManager = (BrokerEventManager)ContextInjectionFactory.make(BrokerEventManager.class, (IEclipseContext)context);
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (this.gateToImport == null) {
            return;
        }
        Transformer.setNumberTasks(1);
        this.progressMonitor.beginTask("Setting up import", 12);
        this.eventManager.async((StudioEvent)new PopUpEvent().setTexts(ImportMap3Messages.importFromMap3, String.valueOf(ImportMap3Messages.importView) + " " + this.gateToImport));
        this.eventManager.sync((StudioEvent)LogEvent.trace(Importer.class, (String)"Extracting elements...", (Object[])new Object[0]));
        Extractor extractor = new Extractor(this.eventManager);
        this.progressMonitor.setTaskName("Extract containers...");
        try {
            extractor.extractContainer(this.gateToImport);
            this.eventManager.sync((StudioEvent)LogEvent.trace(Importer.class, (String)"\tContainers imported.", (Object[])new Object[0]));
        }
        catch (ImportMap3Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
            return;
        }
        this.progressMonitor.internalWorked(1.0);
        this.progressMonitor.setTaskName("Extract media");
        extractor.extractMediaName(this.gateToImport);
        this.eventManager.sync((StudioEvent)LogEvent.trace(Importer.class, (String)"\tMedias imported.", (Object[])new Object[0]));
        this.progressMonitor.internalWorked(1.0);
        this.progressMonitor.setTaskName("Extract links");
        extractor.extractLinks(this.gateToImport);
        this.eventManager.sync((StudioEvent)LogEvent.trace(Importer.class, (String)"\tLinks imported.", (Object[])new Object[0]));
        this.progressMonitor.internalWorked(1.0);
        this.progressMonitor.setTaskName("Extract link template");
        extractor.extractLinkTemplates(this.gateToImport);
        this.eventManager.sync((StudioEvent)LogEvent.trace(Importer.class, (String)"\tLink templates imported.", (Object[])new Object[0]));
        this.progressMonitor.internalWorked(1.0);
        this.eventManager.sync((StudioEvent)LogEvent.trace(Importer.class, (String)"Transforming elements...", (Object[])new Object[0]));
        Transformer transformer = new Transformer(this.context, extractor, this.progressMonitor);
        this.progressMonitor.setTaskName("Run transformation");
        new Thread(transformer).start();
        this.progressMonitor.internalWorked(1.0);
        Transformer transformer2 = transformer;
        synchronized (transformer2) {
            while (!transformer.isFinished()) {
                try {
                    transformer.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.eventManager.sync((StudioEvent)LogEvent.trace(Importer.class, (String)"Transformation done.", (Object[])new Object[0]));
        this.setFinished(true);
    }

    private synchronized void setFinished(boolean finished) {
        this.finished = finished;
        if (this.finished) {
            this.notifyAll();
        }
    }
}

