/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.importmap3;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.model.LatLng;
import com.centreon.studio.client.model.decoration.repository.RepositoryDecorator;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeRelationListener;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.map.client.elements.geo.model.GeoPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.repository.decorators.ElementRepositoryDecorator;
import com.centreon.studio.map.client.importmap3.GateListener;
import com.centreon.studio.map.client.importmap3.extractor.model.map3.Container;
import com.centreon.studio.map.client.importmap3.transformer.ElementCountListener;
import com.centreon.studio.map.client.importmap3.transformer.Transformer;
import com.centreon.studio.map.client.status.model.StatusTypes;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class RootElementListener
implements INodeRelationListener {
    private final Long gateRootContainerId;
    private final Transformer transformer;
    private final RepositoryDecorator elementRepository;
    private final BrokerEventManager eventManager;

    public RootElementListener(IEclipseContext context, Transformer transformer, Long gateRootContainerId) {
        this.gateRootContainerId = gateRootContainerId;
        this.transformer = transformer;
        this.elementRepository = (RepositoryDecorator)ContextInjectionFactory.make(ElementRepositoryDecorator.class, (IEclipseContext)context);
        this.eventManager = (BrokerEventManager)ContextInjectionFactory.make(BrokerEventManager.class, (IEclipseContext)context);
    }

    public void relationsAdded(INode node, Collection<INodeRelation> relations) {
        this.eventManager.sync((StudioEvent)LogEvent.trace(RootElementListener.class, (String)("Relation added for node:" + node + "\nAnd relations: " + relations), (Object[])new Object[0]));
        for (INodeRelation relation : relations) {
            INode target = relation.getTarget();
            if (!this.gateRootContainerId.equals(target.getId())) continue;
            INode template = INodeUtils.copy((INode)target, (boolean)true, (boolean)true, (IRepository)this.elementRepository, (PropertyValue[])new PropertyValue[0]);
            Container view = this.transformer.getExtractor().getCurrentView();
            if (view.getPropertyValue(GeoPropertyDescriptors.IS_GEO.id) != null) {
                template.addPropertyValue(GeoPropertyDescriptors.IS_GEO, (Object)Boolean.parseBoolean(view.getPropertyValue(GeoPropertyDescriptors.IS_GEO.id)));
                template.addPropertyValue(ElementPropertyDescriptors.LATLNG, (Object)LatLng.create((String)view.getPropertyValue(ElementPropertyDescriptors.LATLNG.id)));
            }
            if (view.getPropertyValue("zoom") != null) {
                template.addPropertyValue(PropertyDescriptors.ZOOM, (Object)Double.valueOf(view.getPropertyValue("zoom")));
            }
            this.transformer.progressMonitor.setTaskName("Transform link template");
            this.eventManager.sync((StudioEvent)LogEvent.trace(RootElementListener.class, (String)"Transform link template", (Object[])new Object[0]));
            this.transformer.transformLinkTemplates();
            this.transformer.progressMonitor.worked(1);
            this.transformer.progressMonitor.setTaskName("Start tree transformation");
            this.eventManager.sync((StudioEvent)LogEvent.trace(RootElementListener.class, (String)("Start map3 tree transformation from template: " + template), (Object[])new Object[0]));
            this.transformer.transformMap3Tree(template);
            int nbElements = INodeUtils.getTreeSize((INode)template, Arrays.asList(StatusTypes.METRIC)) - 1;
            this.transformer.progressMonitor.worked(1);
            this.transformer.progressMonitor.setTaskName("Send " + nbElements + " new elements to server");
            this.eventManager.sync((StudioEvent)LogEvent.trace(GateListener.class, (String)("Create ElementCountListener, and register it to target:" + target), (Object[])new Object[0]));
            ElementCountListener elementCountListener = new ElementCountListener(target, this.transformer, nbElements, this.eventManager);
            target.registerRelationsListener((INodeRelationListener)elementCountListener);
            SWTUtils.getDisplay().syncExec(() -> {
                this.eventManager.sync((StudioEvent)LogEvent.trace(GateListener.class, (String)("Perform delta from template to target.\n\ttemplate: " + template + ",\n\ttarget: " + target), (Object[])new Object[0]));
                INodeUtils.performDelta((INode)target, (INode)template);
                target.addPropertyValue(PropertyDescriptors.PREVIOUS_ID, null);
            });
            this.eventManager.sync((StudioEvent)LogEvent.trace(GateListener.class, (String)("Delta performed, modified target: " + target), (Object[])new Object[0]));
            this.elementRepository.unregisterRelationsListener((INodeRelationListener)this);
            break;
        }
    }

    public void relationsRemoved(INode node, Collection<INodeRelation> relations) {
    }
}

