/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.importmap3.extractor;

import com.centreon.studio.client.utils.StringUtils;
import com.centreon.studio.map.client.elements.geo.model.GeoPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.importmap3.ImportMap3Exception;
import com.centreon.studio.map.client.importmap3.extractor.Extractor;
import com.centreon.studio.map.client.importmap3.extractor.XmlUtilities;
import com.centreon.studio.map.client.importmap3.extractor.model.map3.AbstractMap3Object;
import com.centreon.studio.map.client.importmap3.extractor.model.map3.Container;
import com.centreon.studio.map.client.importmap3.extractor.model.map3.ContainerProperty;
import com.centreon.studio.map.client.importmap3.extractor.model.map3.Link;
import com.centreon.studio.map.client.importmap3.messages.ImportMap3Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.DataConversionException;
import org.jdom2.Element;

public class Parser {
    public static final String CTN_ID = "ctn_id";
    private final Extractor extractor;

    private static void parseElementProperty(AbstractMap3Object object, Element property) throws ImportMap3Exception {
        String key = property.getAttribute("param") != null ? XmlUtilities.getAttribString(property, "param") : (property.getAttribute("key") != null ? XmlUtilities.getAttribString(property, "key") : XmlUtilities.getAttribString(property, "name"));
        String value = XmlUtilities.getAttribString(property, "value");
        int type = XmlUtilities.getAttribInt(property, "type");
        ContainerProperty prop = new ContainerProperty(key, value, type);
        if (Boolean.parseBoolean(value) && GeoPropertyDescriptors.IS_GEO.id.equals(key) && StringUtils.isAllNullEmptyOrBlank((String[])new String[]{System.getProperty(GeoPropertyDescriptors.MAPBOX_TOKEN.id)})) {
            throw new ImportMap3Exception(ImportMap3Messages.geolocViewErrorPopup);
        }
        if (ElementPropertyDescriptors.LATLNG.id.equals(key) && object.getPropertyValue(ElementPropertyDescriptors.LATLNG.id) != null) {
            return;
        }
        object.addProperty(prop);
    }

    public Parser(Extractor extractor) {
        this.extractor = extractor;
    }

    public void parseElement(Element element) throws ImportMap3Exception {
        if ("answer".equals(element.getName())) {
            this.parseTopologyList(element);
        }
    }

    public List<Link> parseLinks(Element element) throws ImportMap3Exception {
        ArrayList<Link> links = new ArrayList<Link>(element.getChildren().size());
        if ("answer".equals(element.getName())) {
            for (Element e : element.getChildren()) {
                int linkId = XmlUtilities.getAttribInt(e, "link_id");
                if (linkId == -1) {
                    linkId = XmlUtilities.getAttribInt(e, "id");
                }
                Link link = new Link(linkId);
                link.setType(XmlUtilities.getAttribInt(e, "type"));
                link.setSourceId(XmlUtilities.getAttribLong(e, "ctn_source_id"));
                link.setTargetId(XmlUtilities.getAttribLong(e, "ctn_target_id"));
                link.setName(XmlUtilities.getAttribString(e, "name"));
                link.setAlias(XmlUtilities.getAttribString(e, "alias"));
                link.setHostId(XmlUtilities.getAttribInt(e, "host_id"));
                link.setServiceId(XmlUtilities.getAttribInt(e, "service_id"));
                link.setTemplateId(XmlUtilities.getAttribLong(e, "template_id"));
                for (Element property : e.getChildren("property")) {
                    Parser.parseElementProperty(link, property);
                }
                links.add(link);
            }
            return links;
        }
        return Collections.emptyList();
    }

    public List<Container> parseViews(Element parent) {
        ArrayList<Container> views = new ArrayList<Container>(parent.getChildren().size());
        for (Element element : parent.getChildren("ctn")) {
            Integer ctnId = XmlUtilities.getAttribInt(element, CTN_ID);
            String ctnName = XmlUtilities.getAttribString(element, "name");
            String ctnalias = XmlUtilities.getAttribString(element, "alias");
            Integer type = XmlUtilities.getAttribInt(element, "type");
            Container ctn = new Container(ctnId.intValue());
            ctn.setName(ctnName);
            ctn.setAlias(ctnalias);
            ctn.setType(type);
            for (Element property : element.getChildren()) {
                try {
                    Parser.parseElementProperty(ctn, property);
                }
                catch (ImportMap3Exception importMap3Exception) {
                    ctn.addProperty(new ContainerProperty(GeoPropertyDescriptors.IS_GEO.id, Boolean.TRUE.toString(), 0));
                }
            }
            views.add(ctn);
        }
        return views;
    }

    private void parseCtn(Element element) throws ImportMap3Exception {
        String latlng;
        Integer ctnId = XmlUtilities.getAttribInt(element, CTN_ID);
        String ctnName = XmlUtilities.getAttribString(element, "name");
        String resourceId = XmlUtilities.getAttribString(element, "res_id");
        Integer x = XmlUtilities.getAttribInt(element, "x");
        Integer y = XmlUtilities.getAttribInt(element, "y");
        Integer type = XmlUtilities.getAttribInt(element, "type");
        String isGeoString = XmlUtilities.getAttribString(element, GeoPropertyDescriptors.IS_GEO.id);
        if (isGeoString != null && Boolean.parseBoolean(isGeoString) && StringUtils.isAllNullEmptyOrBlank((String[])new String[]{System.getProperty(GeoPropertyDescriptors.MAPBOX_TOKEN.id)})) {
            throw new ImportMap3Exception(ImportMap3Messages.geolocViewErrorPopup);
        }
        Container ctn = new Container(ctnId.intValue());
        ctn.setName(ctnName);
        ctn.setResourceId(resourceId);
        ctn.setCoordX(x);
        ctn.setCoordY(y);
        ctn.setType(type);
        if (type == 3 && (latlng = this.extractor.getLatLng(Long.valueOf(resourceId))) != null) {
            ctn.addProperty(new ContainerProperty(ElementPropertyDescriptors.LATLNG.id, latlng, 0));
        }
        this.extractor.addContainer(ctn);
    }

    private void parseCtnRelation(Element element) {
        Long source = XmlUtilities.getAttribLong(element, "ctn_parent_id");
        Long target = XmlUtilities.getAttribLong(element, "child_id");
        this.extractor.addCtnRelation(source, target);
    }

    private void parseResources(Element element) {
        try {
            for (Element resource : element.getChildren("resource")) {
                int hostId = resource.getAttribute("host_id").getIntValue();
                String coords = resource.getAttributeValue(ElementPropertyDescriptors.LATLNG.id);
                this.extractor.addHostToLatLng(Long.valueOf(hostId), coords);
            }
        }
        catch (DataConversionException e) {
            e.printStackTrace();
        }
    }

    private void parseTopologyList(Element element) throws ImportMap3Exception {
        List topoList = element.getChildren("topologyList");
        List topoProperties = element.getChildren("topologyProperties");
        List topoRelation = element.getChildren("topologyRelation");
        List resources = element.getChildren("resources");
        for (Element child : resources) {
            Attribute a = child.getAttribute("type");
            if (a == null || !"3".equals(a.getValue())) continue;
            this.parseResources(child);
        }
        for (Element child : topoList) {
            for (Element ctn : child.getChildren()) {
                this.parseCtn(ctn);
            }
        }
        for (Element child : topoProperties) {
            for (Element property : child.getChildren()) {
                Container c = this.extractor.getContainer(XmlUtilities.getAttribLong(property, CTN_ID));
                Parser.parseElementProperty(c, property);
            }
        }
        for (Element child : topoRelation) {
            for (Element relation : child.getChildren()) {
                this.parseCtnRelation(relation);
            }
        }
    }
}

