/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.importmap3.map3.model.authentication;

public class CSServer {
    private static final String DEFAULT_URL = "/centreon/";
    private static final int DEFAULT_PORT = 80;
    private static final int DEFAULT_SSL_PORT = 443;
    private final String name;
    private final String address;
    private final int port;
    private final String url;
    private final boolean useSecureConnexion;

    public CSServer(String name, String address, int port, String url, boolean useSecureConnexion) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name cannot be null or empty");
        }
        if (address == null || address.length() == 0) {
            throw new IllegalArgumentException("address cannot be null or empty");
        }
        this.name = name;
        this.address = address;
        this.port = port > 0 ? port : (useSecureConnexion ? 443 : 80);
        this.url = url != null && url.length() > 0 ? url : DEFAULT_URL;
        this.useSecureConnexion = useSecureConnexion;
    }

    public String computeCompleteUrl() {
        return String.valueOf(this.address) + ":" + this.port + this.url;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CSServer other = (CSServer)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        return this.port;
    }

    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean isUseSecureConnexion() {
        return this.useSecureConnexion;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CSServer [name=");
        builder.append(this.name);
        builder.append(", address=");
        builder.append(this.address);
        builder.append(", port=");
        builder.append(this.port);
        builder.append(", url=");
        builder.append(this.url);
        builder.append(", useSecureConnexion=");
        builder.append(this.useSecureConnexion);
        builder.append("]");
        return builder.toString();
    }
}

