/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.importmap3.map3.model.authentication;

import com.centreon.studio.map.client.importmap3.map3.model.authentication.CSServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.eclipse.swt.widgets.Display;

public class MapX509TrustManager
implements X509TrustManager {
    private static final String KEYSTORE_FILENAME = "centreon.keystore";
    private static final char[] KEYSTORE_PASS = "centreon.keystore.pass".toCharArray();
    private static final String OSGI_INSTANCE_AREA = System.getProperty("osgi.instance.area");
    private static final File KEYSTORE_FILE = new File(MapX509TrustManager.getOsgiRootFolder(), "centreon.keystore");
    private static volatile KeyStore localKeyStore;
    private static volatile KeyStore memoryKeyStore;
    private final X509TrustManager defaultX509TrustManager;
    private final CSServer server;

    static {
        try {
            localKeyStore = KeyStore.getInstance("JKS");
            if (!KEYSTORE_FILE.exists()) {
                localKeyStore.load(null, KEYSTORE_PASS);
                MapX509TrustManager.storeKeyStore();
            } else {
                Throwable throwable = null;
                Object var1_3 = null;
                try (FileInputStream is = new FileInputStream(KEYSTORE_FILE);){
                    localKeyStore.load(is, KEYSTORE_PASS);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            memoryKeyStore = KeyStore.getInstance("JKS");
            memoryKeyStore.load(null, null);
            Enumeration<String> aliases = localKeyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                memoryKeyStore.setCertificateEntry(alias, localKeyStore.getCertificate(alias));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static File getOsgiRootFolder() {
        String arg = OSGI_INSTANCE_AREA.replaceAll("file:", "");
        File folder = new File(arg);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }

    private static synchronized void storeKeyStore() throws Exception {
        Throwable throwable = null;
        Object var1_2 = null;
        try (FileOutputStream fos = new FileOutputStream(KEYSTORE_FILE);){
            localKeyStore.store(fos, KEYSTORE_PASS);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public MapX509TrustManager(CSServer server) throws Exception {
        TrustManager[] tms;
        this.server = server;
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
        tmf.init(memoryKeyStore);
        TrustManager[] trustManagerArray = tms = tmf.getTrustManagers();
        int n = tms.length;
        int n2 = 0;
        while (n2 < n) {
            TrustManager tm = trustManagerArray[n2];
            if (tm instanceof X509TrustManager) {
                this.defaultX509TrustManager = (X509TrustManager)tm;
                return;
            }
            ++n2;
        }
        throw new Exception("Couldn't initialize custom X509TrustManager");
    }

    @Override
    public synchronized void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.defaultX509TrustManager.checkClientTrusted(chain, authType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void checkServerTrusted(final X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.defaultX509TrustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException certificateException) {
            KeyStore keyStore = memoryKeyStore;
            synchronized (keyStore) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String alias = MapX509TrustManager.this.server.computeCompleteUrl();
                        try {
                            memoryKeyStore.setCertificateEntry(alias, chain[0]);
                        }
                        catch (KeyStoreException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
    }

    @Override
    public synchronized X509Certificate[] getAcceptedIssuers() {
        return this.defaultX509TrustManager.getAcceptedIssuers();
    }
}

