/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.importmap3.transformer;

import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.media.model.MediaPropertyDescriptors;
import com.centreon.studio.client.media.model.MediaTypes;
import com.centreon.studio.client.model.LatLng;
import com.centreon.studio.client.model.Line;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.StudioColor;
import com.centreon.studio.client.model.StudioFont;
import com.centreon.studio.client.model.StyleTypes;
import com.centreon.studio.client.model.decoration.repository.RepositoryDecorator;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.node.NodeFactories;
import com.centreon.studio.client.model.object.AObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertySerializer;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.layer.LayersRegistry;
import com.centreon.studio.client.utils.SequenceUtils;
import com.centreon.studio.map.client.elements.bam.model.BAMElementTypes;
import com.centreon.studio.map.client.elements.geo.model.GeoPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import com.centreon.studio.map.client.elements.model.LinkType;
import com.centreon.studio.map.client.elements.templates.TemplateTypes;
import com.centreon.studio.map.client.elements.widgets.model.WidgetTypes;
import com.centreon.studio.map.client.gates.model.GateTypes;
import com.centreon.studio.map.client.importmap3.extractor.Extractor;
import com.centreon.studio.map.client.importmap3.extractor.model.map3.Container;
import com.centreon.studio.map.client.importmap3.extractor.model.map3.Link;
import com.centreon.studio.map.client.importmap3.transformer.Map3Types;
import com.centreon.studio.map.client.resources.bam.model.BAMResourceTypes;
import com.centreon.studio.map.client.resources.model.ResourceTypes;
import com.centreon.studio.map.client.resources.utils.StudioIdUtils;
import com.centreon.studio.map.client.status.model.StatusTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ElementTransformer {
    private static final Pattern PATTERN = Pattern.compile("RGB \\{(\\d+), (\\d+), (\\d+)\\}");
    private static Map<Integer, TypeDescriptor> TYPE_CONVERTOR = new HashMap<Integer, TypeDescriptor>(13);
    private static Map<Integer, TypeDescriptor> MAP3_TO_MAP4_TYPES = new HashMap<Integer, TypeDescriptor>(10);
    private static Map<String, Line> STYLE_MAPPING = new HashMap<String, Line>(10);
    private static Map<Integer, LinkType> LINK_TYPE_MAPPING = new HashMap<Integer, LinkType>(7);
    private static Set<TypeDescriptor> RESOURCE_ELEMENTS = new HashSet<TypeDescriptor>(8);
    private static final Map<Long, INode> PREVIOUS_TEMPALTE_ID_TO_NEW_NODE = new HashMap<Long, INode>(10);
    private static final Set<String> TRAFFIC_LINK_IN_METRIC_NAME = new HashSet<String>(6);
    private static final Set<String> TRAFFIC_LINK_OUT_METRIC_NAME = new HashSet<String>(6);
    private final Extractor extractor;
    private final BrokerEventManager eventManager;
    private final RepositoryDecorator mediaRepository;
    private final RepositoryDecorator elementRepository;
    private final RepositoryDecorator resourceRepository;

    static {
        TYPE_CONVERTOR.put(Map3Types.typeBa, BAMElementTypes.ELEMENT_BA);
        TYPE_CONVERTOR.put(Map3Types.typeHost, ElementTypes.ELEMENT_HOST);
        TYPE_CONVERTOR.put(Map3Types.typeKpi, BAMElementTypes.ELEMENT_KPI);
        TYPE_CONVERTOR.put(Map3Types.typeService, ElementTypes.ELEMENT_SERVICE);
        TYPE_CONVERTOR.put(Map3Types.typeContener, ElementTypes.ELEMENT_CONTAINER);
        TYPE_CONVERTOR.put(Map3Types.typeShortcut, ElementTypes.ELEMENT_CONTAINER);
        TYPE_CONVERTOR.put(Map3Types.typeHostGroup, ElementTypes.ELEMENT_HOST_GROUP);
        TYPE_CONVERTOR.put(Map3Types.typeServiceGroup, ElementTypes.ELEMENT_SERVICE_GROUP);
        TYPE_CONVERTOR.put(Map3Types.typeMetaService, ElementTypes.ELEMENT_SERVICE_META);
        TYPE_CONVERTOR.put(Map3Types.typeImage, ElementTypes.ELEMENT_MEDIA_IMAGE);
        TYPE_CONVERTOR.put(Map3Types.typeText, ElementTypes.ELEMENT_SHAPE);
        TYPE_CONVERTOR.put(Map3Types.typeFormCarre, ElementTypes.ELEMENT_SHAPE);
        TYPE_CONVERTOR.put(Map3Types.typeFormEllipse, ElementTypes.ELEMENT_SHAPE);
        RESOURCE_ELEMENTS.add(ElementTypes.ELEMENT_HOST);
        RESOURCE_ELEMENTS.add(BAMElementTypes.ELEMENT_BA);
        RESOURCE_ELEMENTS.add(BAMElementTypes.ELEMENT_KPI);
        RESOURCE_ELEMENTS.add(ElementTypes.ELEMENT_SERVICE);
        RESOURCE_ELEMENTS.add(ElementTypes.ELEMENT_CONTAINER);
        RESOURCE_ELEMENTS.add(ElementTypes.ELEMENT_HOST_GROUP);
        RESOURCE_ELEMENTS.add(ElementTypes.ELEMENT_SERVICE_GROUP);
        RESOURCE_ELEMENTS.add(ElementTypes.ELEMENT_SERVICE_META);
        MAP3_TO_MAP4_TYPES.put(3, ResourceTypes.RESOURCE_HOST);
        MAP3_TO_MAP4_TYPES.put(6, BAMResourceTypes.RESOURCE_BA);
        MAP3_TO_MAP4_TYPES.put(20, BAMResourceTypes.RESOURCE_KPI);
        MAP3_TO_MAP4_TYPES.put(5, ResourceTypes.RESOURCE_SERVICE);
        MAP3_TO_MAP4_TYPES.put(2, ResourceTypes.RESOURCE_HOST_GROUP);
        MAP3_TO_MAP4_TYPES.put(4, ResourceTypes.RESOURCE_SERVICE_GROUP);
        MAP3_TO_MAP4_TYPES.put(7, ResourceTypes.RESOURCE_SERVICE_META);
        STYLE_MAPPING.put("0", Line.SOLID);
        STYLE_MAPPING.put("1", Line.SOLID);
        STYLE_MAPPING.put("2", Line.DASH);
        STYLE_MAPPING.put("3", Line.DOT);
        STYLE_MAPPING.put("4", Line.DASHDOT);
        STYLE_MAPPING.put("5", Line.DASHDOTDOT);
        STYLE_MAPPING.put("6", Line.SOLID);
        LINK_TYPE_MAPPING.put(0, LinkType.SIMPLE);
        LINK_TYPE_MAPPING.put(6, LinkType.STATUS);
        LINK_TYPE_MAPPING.put(7, LinkType.METRIC);
        LINK_TYPE_MAPPING.put(8, LinkType.METRIC);
        TRAFFIC_LINK_IN_METRIC_NAME.add("inbound");
        TRAFFIC_LINK_IN_METRIC_NAME.add("inbounds");
        TRAFFIC_LINK_IN_METRIC_NAME.add("trafic_in");
        TRAFFIC_LINK_IN_METRIC_NAME.add("in_trafic");
        TRAFFIC_LINK_IN_METRIC_NAME.add("traffic_in");
        TRAFFIC_LINK_IN_METRIC_NAME.add("in_traffic");
        TRAFFIC_LINK_OUT_METRIC_NAME.add("outbound");
        TRAFFIC_LINK_OUT_METRIC_NAME.add("outbounds");
        TRAFFIC_LINK_OUT_METRIC_NAME.add("trafic_out");
        TRAFFIC_LINK_OUT_METRIC_NAME.add("out_trafic");
        TRAFFIC_LINK_OUT_METRIC_NAME.add("traffic_out");
        TRAFFIC_LINK_OUT_METRIC_NAME.add("out_traffic");
    }

    private static void addImageElementProperties(Container container, List<PropertyValue> properties, IRepository mediaRepository) {
        INode media = INodeUtils.findNode((INode)mediaRepository, (TypeDescriptor)MediaTypes.MEDIA_IMAGE, null, (PropertyValue[])new PropertyValue[]{new PropertyValue(MediaPropertyDescriptors.CENTREON_ID, (Object)Long.parseLong(container.getResourceId()))});
        if (media != null) {
            properties.add(new PropertyValue(MediaPropertyDescriptors.MD5, (Object)((String)media.getProperty(MediaPropertyDescriptors.MD5))));
        }
    }

    private static void addShapeProperties(Container container, List<PropertyValue> properties) {
        if (container.getType() == Map3Types.typeFormEllipse) {
            properties.add(new PropertyValue(PropertyDescriptors.SHAPE, (Object)"ellipse"));
        } else {
            properties.add(new PropertyValue(PropertyDescriptors.SHAPE, (Object)"rectangle"));
        }
        if (container.getType() == Map3Types.typeText) {
            properties.add(new PropertyValue(PropertyDescriptors.BORDER_COLOR, (Object)StudioColor.WHITE));
            String fontData = container.getPropertyValue("fontData");
            Pos dim = Pos.create((String)ElementTransformer.computeSize(container.getName(), fontData));
            int x = container.getCoordX();
            int y = container.getCoordY();
            x = (int)((double)x + dim.x / 2.0);
            y = (int)((double)y + dim.y / 2.0);
            properties.add(new PropertyValue(PropertyDescriptors.POSITION, (Object)Pos.create((double)x, (double)y)));
            properties.add(new PropertyValue(PropertyDescriptors.DIMENSION, (Object)Pos.create((String)ElementTransformer.computeSize(container.getName(), fontData))));
        } else {
            properties.add(new PropertyValue(AObject.LABEL, (Object)""));
        }
        properties.add(new PropertyValue(PropertyDescriptors.LAYER, (Object)LayersRegistry.BACKGROUND_LAYER.toString()));
    }

    private static String computeSize(String label, String fontData) {
        String[] lines = label.split("\r\n");
        String stringSize = fontData.split("\\|")[2];
        Double size = Double.parseDouble(stringSize);
        int length = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            length = Math.max(line.length(), length);
            ++n2;
        }
        return String.valueOf((double)length * size - size) + "," + size * (double)lines.length * 2.0;
    }

    private static String findMetricInService(Collection<String> matches, INode service, String defaultValue, BrokerEventManager eventManager) {
        for (INodeRelation relation : service.getRelations(new TypeDescriptor[]{StatusTypes.METRIC})) {
            INode metric = relation.getTarget();
            eventManager.sync((StudioEvent)LogEvent.trace(ElementTransformer.class, (String)("   metric: " + metric.getLabel()), (Object[])new Object[0]));
            for (String match : matches) {
                eventManager.sync((StudioEvent)LogEvent.trace(ElementTransformer.class, (String)("      match: " + match), (Object[])new Object[0]));
                if (!metric.getLabel().toLowerCase().contains(match.toLowerCase())) continue;
                eventManager.sync((StudioEvent)LogEvent.trace(ElementTransformer.class, (String)"      -> FOUND!", (Object[])new Object[0]));
                return metric.getLabel();
            }
        }
        return defaultValue;
    }

    private static StudioFont getFontFromString(String fontData) {
        String[] splitFontData = fontData.split("\\|");
        String newFontData = splitFontData[1];
        newFontData = String.valueOf(newFontData) + "#" + splitFontData[0];
        newFontData = String.valueOf(newFontData) + "#" + splitFontData[3];
        newFontData = String.valueOf(newFontData) + "#" + Double.valueOf(splitFontData[2]).intValue();
        PropertySerializer fontSerializer = PropertySerializer.getPropertySerializer(StudioFont.class);
        return (StudioFont)fontSerializer.toObject(newFontData);
    }

    private static long getResourceId(String resourceId, TypeDescriptor type) {
        if (type == null) {
            return -1L;
        }
        if (resourceId.contains("_")) {
            String[] ids = resourceId.split("_");
            Integer hostId = Integer.parseInt(ids[0]);
            Integer serviceId = Integer.parseInt(ids[1]);
            return StudioIdUtils.createResourceId((int)hostId, (int)serviceId);
        }
        return Long.parseLong(resourceId);
    }

    private static String rgbToHex(String rgb) {
        Matcher matcher = PATTERN.matcher(rgb);
        if (matcher.matches()) {
            String one = Integer.toHexString(Integer.parseInt(matcher.group(1)));
            String two = Integer.toHexString(Integer.parseInt(matcher.group(2)));
            String tree = Integer.toHexString(Integer.parseInt(matcher.group(3)));
            one = one.length() == 2 ? one : "0" + one;
            two = two.length() == 2 ? two : "0" + two;
            tree = tree.length() == 2 ? tree : "0" + tree;
            return "#" + one + two + tree;
        }
        return StudioColor.WHITE.toHexadecimal();
    }

    public ElementTransformer(BrokerEventManager eventManager, RepositoryDecorator elementRepository, Extractor extractor, RepositoryDecorator mediaRepository, RepositoryDecorator resourceRepository) {
        this.extractor = extractor;
        this.eventManager = eventManager;
        this.mediaRepository = mediaRepository;
        this.elementRepository = elementRepository;
        this.resourceRepository = resourceRepository;
    }

    public void addPreviousLinkTemplate(Long previousId, INode newNode) {
        PREVIOUS_TEMPALTE_ID_TO_NEW_NODE.put(previousId, newNode);
    }

    public INode transformContainer(Container container) {
        StudioColor studioColor;
        String hexaColor;
        String style;
        TypeDescriptor type = TYPE_CONVERTOR.get(container.getType());
        if (type == null) {
            return null;
        }
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>(20);
        String width = container.getPropertyValue("width");
        String height = container.getPropertyValue("height");
        String backgroundColor = container.getPropertyValue("backgroundRGB");
        String fontColor = container.getPropertyValue("foregroundRGB");
        String opacity = container.getPropertyValue("opacity");
        String latlong = container.getPropertyValue(ElementPropertyDescriptors.LATLNG.id);
        String zoom = container.getPropertyValue("zoom");
        String isGeo = container.getPropertyValue(GeoPropertyDescriptors.IS_GEO.id);
        if (isGeo != null) {
            properties.add(new PropertyValue(GeoPropertyDescriptors.IS_GEO, (Object)Boolean.parseBoolean(isGeo)));
        }
        if (zoom != null) {
            properties.add(new PropertyValue(PropertyDescriptors.ZOOM, (Object)Double.parseDouble(zoom)));
        }
        if (latlong != null) {
            properties.add(new PropertyValue(ElementPropertyDescriptors.LATLNG, (Object)LatLng.create((String)latlong)));
        }
        if ((style = container.getPropertyValue("style")) != null) {
            if ("3".equals(style)) {
                type = WidgetTypes.WIDGET_LINE_CHART;
                width = width == null ? "700" : width;
                height = height == null ? "250" : height;
            } else if ("1".equals(style)) {
                properties.add(new PropertyValue(PropertyDescriptors.STYLE, (Object)StyleTypes.GEOMETRIC_STYLE));
            }
        }
        properties.add(new PropertyValue(AObject.LABEL, (Object)container.getName()));
        Integer x = container.getCoordX();
        Integer y = container.getCoordY();
        if (width != null && height != null) {
            if (style != null && !"3".equals(style) && !"1".equals(style)) {
                width = String.valueOf(Math.max(Integer.valueOf(width), 84));
                height = String.valueOf(Math.max(Integer.valueOf(height), 84));
            }
            properties.add(new PropertyValue(PropertyDescriptors.DIMENSION, (Object)Pos.create((String)(String.valueOf(width) + "," + height))));
            if (!RESOURCE_ELEMENTS.contains(type)) {
                x = x + Integer.parseInt(width) / 2;
                y = y + Integer.parseInt(height) / 2;
            }
        }
        properties.add(new PropertyValue(PropertyDescriptors.POSITION, (Object)Pos.create((double)x.intValue(), (double)y.intValue())));
        properties.add(new PropertyValue(PropertyDescriptors.PREVIOUS_ID, (Object)container.getId()));
        if (container.getResourceId() != null) {
            properties.add(new PropertyValue(ElementPropertyDescriptors.RESOURCE_ID, (Object)ElementTransformer.getResourceId(container.getResourceId(), type)));
        }
        properties.add(new PropertyValue(ElementPropertyDescriptors.RESOURCE_TYPE, (Object)MAP3_TO_MAP4_TYPES.get(container.getType())));
        String fontData = container.getPropertyValue("fontData");
        if (fontData != null) {
            properties.add(new PropertyValue(PropertyDescriptors.FONT, (Object)ElementTransformer.getFontFromString(fontData)));
        }
        if (backgroundColor != null) {
            hexaColor = ElementTransformer.rgbToHex(backgroundColor);
            studioColor = StudioColor.fromHexadecimal((String)hexaColor);
            properties.add(new PropertyValue(PropertyDescriptors.COLOR, (Object)studioColor));
        } else {
            properties.add(new PropertyValue(PropertyDescriptors.COLOR, (Object)StudioColor.WHITE));
        }
        if (fontColor != null) {
            hexaColor = ElementTransformer.rgbToHex(fontColor);
            studioColor = StudioColor.fromHexadecimal((String)hexaColor);
            properties.add(new PropertyValue(PropertyDescriptors.FONT_COLOR, (Object)studioColor));
        }
        if (opacity != null) {
            properties.add(new PropertyValue(PropertyDescriptors.ALPHA, (Object)Integer.parseInt(opacity)));
        }
        if (type == ElementTypes.ELEMENT_MEDIA_IMAGE) {
            ElementTransformer.addImageElementProperties(container, properties, (IRepository)this.mediaRepository);
            if (width == null) {
                this.addDimensionToImage(this.extractor.getImageNameFromId(Long.valueOf(container.getResourceId())), properties, x, y);
            }
        } else if (type == ElementTypes.ELEMENT_SHAPE) {
            ElementTransformer.addShapeProperties(container, properties);
        }
        if (container.getType() == Map3Types.typeFormCarre || container.getType() == Map3Types.typeFormEllipse || container.getType() == Map3Types.typeImage) {
            properties.add(new PropertyValue(PropertyDescriptors.LAYER, (Object)LayersRegistry.BACKGROUND_LAYER.toString()));
        } else {
            properties.add(new PropertyValue(PropertyDescriptors.LAYER, (Object)LayersRegistry.getTopLayer()));
        }
        INode node = NodeFactories.INSTANCE.create(type, SequenceUtils.next(), properties, (IRepository)this.elementRepository);
        return node;
    }

    public INode transformGate(Container view, IRepository repository) {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>(10);
        String gateName = view.getName();
        long previousGateId = SequenceUtils.next();
        properties.add(new PropertyValue(AObject.LABEL, (Object)gateName));
        properties.add(new PropertyValue(PropertyDescriptors.PREVIOUS_ID, (Object)previousGateId));
        return NodeFactories.INSTANCE.create(GateTypes.GATE, Long.valueOf(previousGateId), properties, repository);
    }

    public INode transformLink(Link link, TypeDescriptor linkType) {
        String style;
        String stringSize;
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>(10);
        properties.add(new PropertyValue(PropertyDescriptors.DESCRIPTION, (Object)link.getAlias()));
        properties.add(new PropertyValue(AObject.LABEL, (Object)link.getName()));
        properties.add(new PropertyValue(ElementPropertyDescriptors.LINK_TARGET_ID, (Object)link.getSourceId()));
        properties.add(new PropertyValue(ElementPropertyDescriptors.LINK_SOURCE_ID, (Object)link.getTargetId()));
        if (link.getTemplateId() > 0L) {
            this.addTemplateProperties(link, properties);
        }
        if ((stringSize = link.getPropertyValue("size")) != null && !"-1".equals(stringSize)) {
            Integer size = Integer.parseInt(stringSize);
            properties.add(new PropertyValue(PropertyDescriptors.THICKNESS, (Object)(size + 1)));
        } else {
            properties.add(new PropertyValue(PropertyDescriptors.THICKNESS, (Object)2));
        }
        String stringColor = link.getPropertyValue("color");
        if (stringColor != null) {
            String hexaColor = ElementTransformer.rgbToHex(stringColor);
            StudioColor studioColor = StudioColor.fromHexadecimal((String)hexaColor);
            properties.add(new PropertyValue(PropertyDescriptors.COLOR, (Object)studioColor));
        }
        if ((style = link.getPropertyValue("line")) != null) {
            properties.add(new PropertyValue(PropertyDescriptors.LINE, (Object)STYLE_MAPPING.get(style)));
        }
        Long serviceId = StudioIdUtils.createResourceId((int)link.getHostId(), (int)link.getServiceId());
        properties.add(new PropertyValue(ElementPropertyDescriptors.RESOURCE_ID, (Object)serviceId));
        properties.add(new PropertyValue(ElementPropertyDescriptors.RESOURCE_TYPE, (Object)ResourceTypes.RESOURCE_SERVICE));
        LinkType lt = LINK_TYPE_MAPPING.get(link.getType());
        properties.add(new PropertyValue(ElementPropertyDescriptors.LINK_TYPE, (Object)lt));
        if (lt == LinkType.METRIC) {
            properties.addAll(this.addMetricLinkRelations(link));
        } else {
            properties.add(new PropertyValue(PropertyDescriptors.NEED_UPDATE, (Object)Boolean.TRUE));
        }
        if (linkType == TemplateTypes.TEMPLATE_LINK) {
            properties.add(new PropertyValue(PropertyDescriptors.DISPLAY_LABEL, (Object)false));
        }
        return NodeFactories.INSTANCE.create(linkType, SequenceUtils.next(), properties, (IRepository)this.elementRepository);
    }

    private void addDimensionToImage(String name, Collection<PropertyValue> properties, int x, int y) {
        INode media;
        if (name != null && (media = INodeUtils.findNode((INode)this.mediaRepository, (TypeDescriptor)MediaTypes.MEDIA_IMAGE, null, (PropertyValue[])new PropertyValue[]{new PropertyValue(AObject.LABEL, (Object)name)})) != null) {
            Pos dim = (Pos)media.getProperty(PropertyDescriptors.DIMENSION);
            Pos pos = Pos.create((double)((double)x + dim.x / 2.0), (double)((double)y + dim.y / 2.0));
            properties.add(new PropertyValue(PropertyDescriptors.DIMENSION, (Object)((Pos)media.getProperty(PropertyDescriptors.DIMENSION))));
            properties.add(new PropertyValue(PropertyDescriptors.POSITION, (Object)pos));
        }
    }

    private Collection<PropertyValue> addMetricLinkRelations(Link link) {
        this.eventManager.sync((StudioEvent)LogEvent.trace(ElementTransformer.class, (String)"Add metric for link", (Object[])new Object[0]));
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>(4);
        Long serviceId = StudioIdUtils.createResourceId((int)link.getHostId(), (int)link.getServiceId());
        String metricIn = link.getPropertyValue("metricIn");
        String metricOut = link.getPropertyValue("metricOut");
        this.eventManager.sync((StudioEvent)LogEvent.trace(ElementTransformer.class, (String)("   metricIn : " + metricIn), (Object[])new Object[0]));
        this.eventManager.sync((StudioEvent)LogEvent.trace(ElementTransformer.class, (String)("   metricOut: " + metricOut), (Object[])new Object[0]));
        INode s = INodeUtils.findNode((INode)this.resourceRepository, (TypeDescriptor)ResourceTypes.RESOURCE_SERVICE, (Long)serviceId, (PropertyValue[])new PropertyValue[0]);
        if (s == null) {
            this.eventManager.sync((StudioEvent)LogEvent.trace(ElementTransformer.class, (String)"   Associated service: NOT FOUND", (Object[])new Object[0]));
        } else {
            this.eventManager.sync((StudioEvent)LogEvent.trace(ElementTransformer.class, (String)("   Associated service: " + s.getLabel()), (Object[])new Object[0]));
            StringBuilder metrics = new StringBuilder("      List of available metrics:\n");
            for (INodeRelation relation : s.getRelations(new TypeDescriptor[]{StatusTypes.METRIC})) {
                metrics.append("         -> " + relation.getTarget().getLabel() + "\n");
            }
            this.eventManager.sync((StudioEvent)LogEvent.trace(ElementTransformer.class, (String)metrics.toString(), (Object[])new Object[0]));
        }
        boolean foundMetricIn = INodeUtils.findRelationForTarget((INode)s, (TypeDescriptor)StatusTypes.METRIC, null, (PropertyValue[])new PropertyValue[]{new PropertyValue(AObject.LABEL, (Object)metricIn)}) != null;
        boolean foundMetricOut = INodeUtils.findRelationForTarget((INode)s, (TypeDescriptor)StatusTypes.METRIC, null, (PropertyValue[])new PropertyValue[]{new PropertyValue(AObject.LABEL, (Object)metricOut)}) != null;
        metricIn = metricIn == null ? "traffic_in" : metricIn;
        String string = metricOut = metricOut == null ? "traffic_out" : metricOut;
        if (s != null && !foundMetricIn) {
            metricIn = ElementTransformer.findMetricInService(TRAFFIC_LINK_IN_METRIC_NAME, s, metricIn, this.eventManager);
            this.eventManager.sync((StudioEvent)LogEvent.trace(ElementTransformer.class, (String)("      Search metricIn: " + metricIn), (Object[])new Object[0]));
        }
        if (s != null && !foundMetricOut) {
            metricOut = ElementTransformer.findMetricInService(TRAFFIC_LINK_OUT_METRIC_NAME, s, metricOut, this.eventManager);
            this.eventManager.sync((StudioEvent)LogEvent.trace(ElementTransformer.class, (String)("      Search metricOut: " + metricOut), (Object[])new Object[0]));
        }
        this.eventManager.sync((StudioEvent)LogEvent.trace(ElementTransformer.class, (String)("   Conclusion:\n   MetricIn : " + metricIn + "\n   MetricOut: " + metricOut), (Object[])new Object[0]));
        properties.add(new PropertyValue(ElementPropertyDescriptors.METRIC_SOURCE, (Object)metricIn));
        properties.add(new PropertyValue(ElementPropertyDescriptors.METRIC_TARGET, (Object)metricOut));
        properties.add(new PropertyValue(ElementPropertyDescriptors.LINK_TYPE, (Object)LinkType.METRIC));
        properties.add(new PropertyValue(ElementPropertyDescriptors.LINK_IS_DOUBLE, (Object)(link.getType() == 7 ? 1 : 0)));
        properties.add(new PropertyValue(PropertyDescriptors.NEED_UPDATE, (Object)Boolean.TRUE));
        return properties;
    }

    private final void addTemplateProperties(Link link, Collection<PropertyValue> properties) {
        INode template = PREVIOUS_TEMPALTE_ID_TO_NEW_NODE.get(link.getTemplateId());
        if (template != null) {
            properties.add(new PropertyValue(ElementPropertyDescriptors.TEMPLATE_ID, (Object)template.getId()));
            properties.add(new PropertyValue(ElementPropertyDescriptors.LINK_TYPE, (Object)((LinkType)template.getProperty(ElementPropertyDescriptors.LINK_TYPE))));
            properties.add(new PropertyValue(ElementPropertyDescriptors.LINK_IS_DOUBLE, (Object)((Boolean)template.getProperty(ElementPropertyDescriptors.LINK_IS_DOUBLE))));
            Link t = this.extractor.getLinkTemplates().get(link.getTemplateId());
            if (t != null) {
                link.setType(t.getType());
            }
        }
    }
}

