/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.importmap3.transformer;

import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.events.popup.PopUpEvent;
import com.centreon.studio.client.media.model.MediaRepositoryDecorator;
import com.centreon.studio.client.model.LatLng;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.StudioTypes;
import com.centreon.studio.client.model.decoration.repository.RepositoryDecorator;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeRelationListener;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.AObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.utils.SequenceUtils;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import com.centreon.studio.map.client.elements.model.repository.decorators.ElementRepositoryDecorator;
import com.centreon.studio.map.client.elements.templates.TemplateRepositoryDecorator;
import com.centreon.studio.map.client.elements.templates.TemplateTypes;
import com.centreon.studio.map.client.gates.model.GateRepositoryDecorator;
import com.centreon.studio.map.client.importmap3.GateListener;
import com.centreon.studio.map.client.importmap3.extractor.Extractor;
import com.centreon.studio.map.client.importmap3.extractor.model.map3.Container;
import com.centreon.studio.map.client.importmap3.extractor.model.map3.Link;
import com.centreon.studio.map.client.importmap3.messages.ImportMap3Messages;
import com.centreon.studio.map.client.importmap3.transformer.ElementTransformer;
import com.centreon.studio.map.client.resources.model.repository.decorators.ResourceRepositoryDecorator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class Transformer
implements Runnable {
    private static int TASK_DONE = 0;
    private static int NUMBER_TASKS = 0;
    private static Map<Integer, TypeDescriptor> TYPE_CONVERTOR = new HashMap<Integer, TypeDescriptor>(10);
    private static Set<PropertyDescriptor<?>> TEMPLATE_VALUES_TO_COMPARE = new HashSet(10);
    public final IProgressMonitor progressMonitor;
    private final IEclipseContext context;
    private final List<INode> newRoots = new ArrayList<INode>();
    private final Map<Long, INode> newNodes = new HashMap<Long, INode>();
    private final Extractor extractor;
    private final ElementTransformer elementTransformer;
    private final RepositoryDecorator elementRepository;
    private final BrokerEventManager eventManager;
    private boolean isFinished = false;

    static {
        TYPE_CONVERTOR.put(1, ElementTypes.ELEMENT_CONTAINER);
        TYPE_CONVERTOR.put(3, ElementTypes.ELEMENT_HOST);
        TYPE_CONVERTOR.put(4, ElementTypes.ELEMENT_SERVICE_GROUP);
        TYPE_CONVERTOR.put(5, ElementTypes.ELEMENT_SERVICE);
        TYPE_CONVERTOR.put(7, ElementTypes.ELEMENT_SERVICE_META);
        TEMPLATE_VALUES_TO_COMPARE.add(PropertyDescriptors.LINE);
        TEMPLATE_VALUES_TO_COMPARE.add(PropertyDescriptors.THICKNESS);
        TEMPLATE_VALUES_TO_COMPARE.add(ElementPropertyDescriptors.LINK_TYPE);
        TEMPLATE_VALUES_TO_COMPARE.add(ElementPropertyDescriptors.METRIC_SOURCE);
        TEMPLATE_VALUES_TO_COMPARE.add(ElementPropertyDescriptors.METRIC_TARGET);
        TEMPLATE_VALUES_TO_COMPARE.add(AObject.LABEL);
    }

    public static synchronized void resetTaskDoneCounter() {
        TASK_DONE = 0;
    }

    public static synchronized void sendTaskDonePopUp(String gateName, BrokerEventManager eventManager) {
        ++TASK_DONE;
        PopUpEvent pe = new PopUpEvent();
        StringBuilder sb = new StringBuilder();
        sb.append(ImportMap3Messages.importView);
        sb.append(gateName);
        sb.append(" ");
        sb.append(ImportMap3Messages.finishImportingView);
        sb.append(". ");
        sb.append(TASK_DONE);
        sb.append("/");
        sb.append(NUMBER_TASKS);
        pe.setTexts(ImportMap3Messages.importView, sb.toString());
        pe.setImagePath("platform:/plugin/com.centreon.studio.client.events/img/ok.png");
        eventManager.async((StudioEvent)pe);
    }

    public static synchronized void setNumberTasks(int numberTasks) {
        NUMBER_TASKS = numberTasks;
    }

    private static INode checkAlreadyExistingTemplate(RepositoryDecorator repository, INode newNode) {
        PropertyValue[] properties = new PropertyValue[newNode.getPropertyValues().size()];
        int i = 0;
        for (PropertyValue propertyValue : newNode.getPropertyValues()) {
            if (!TEMPLATE_VALUES_TO_COMPARE.contains(propertyValue.getProperty())) continue;
            properties[i++] = propertyValue;
        }
        PropertyValue[] cleanArrayOfProperties = Arrays.copyOfRange(properties, 0, i);
        return INodeUtils.findNode((INode)repository, (TypeDescriptor)TemplateTypes.TEMPLATE_LINK, null, (PropertyValue[])cleanArrayOfProperties);
    }

    public Transformer(IEclipseContext context, Extractor extractor, IProgressMonitor progressMonitor) {
        this.context = context;
        this.extractor = extractor;
        this.progressMonitor = progressMonitor;
        this.elementRepository = (RepositoryDecorator)ContextInjectionFactory.make(ElementRepositoryDecorator.class, (IEclipseContext)this.context);
        RepositoryDecorator mediaRepository = (RepositoryDecorator)ContextInjectionFactory.make(MediaRepositoryDecorator.class, (IEclipseContext)this.context);
        RepositoryDecorator resourceRepository = (RepositoryDecorator)ContextInjectionFactory.make(ResourceRepositoryDecorator.class, (IEclipseContext)this.context);
        this.eventManager = (BrokerEventManager)ContextInjectionFactory.make(BrokerEventManager.class, (IEclipseContext)context);
        this.elementTransformer = new ElementTransformer(this.eventManager, this.elementRepository, this.extractor, mediaRepository, resourceRepository);
    }

    public Extractor getExtractor() {
        return this.extractor;
    }

    public List<INode> getNewNodes() {
        return Collections.unmodifiableList(this.newRoots);
    }

    public synchronized boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public void run() {
        this.newNodes.clear();
        this.newRoots.clear();
        GateRepositoryDecorator gateRepository = (GateRepositoryDecorator)ContextInjectionFactory.make(GateRepositoryDecorator.class, (IEclipseContext)this.context);
        Container view = this.extractor.getCurrentView();
        INode viewAsNode = this.elementTransformer.transformGate(view, (IRepository)gateRepository);
        Long previousGateId = viewAsNode.getId();
        this.eventManager.sync((StudioEvent)LogEvent.trace(Transformer.class, (String)"Create GateListener, and register it to GateRepository.", (Object[])new Object[0]));
        GateListener gateListener = new GateListener(this.context, (IRepository)gateRepository, this.elementRepository, previousGateId, this);
        gateRepository.registerRelationsListener((INodeRelationListener)gateListener);
        this.eventManager.sync((StudioEvent)LogEvent.trace(Transformer.class, (String)"Create relation beetween GateRepository and ViewAsNode, then add this relation to GateRepository.", (Object[])new Object[0]));
        INodeRelation relation = NodeRelationFactories.INSTANCE.create((INode)gateRepository, viewAsNode);
        gateRepository.addRelation(relation);
    }

    public synchronized void setFinished(boolean finished) {
        this.isFinished = finished;
        if (this.isFinished) {
            this.notifyAll();
        }
    }

    public void transformLinkTemplates() {
        TemplateRepositoryDecorator linkTemplateRepository = (TemplateRepositoryDecorator)ContextInjectionFactory.make(TemplateRepositoryDecorator.class, (IEclipseContext)this.context);
        linkTemplateRepository.registerRelationsListener(new INodeRelationListener(){

            public void relationsAdded(INode node, Collection<INodeRelation> relations) {
                for (INodeRelation relation : relations) {
                    if (relation.getTarget().getProperty(PropertyDescriptors.PREVIOUS_ID) == null) continue;
                    Transformer.this.elementTransformer.addPreviousLinkTemplate((Long)relation.getTarget().getProperty(PropertyDescriptors.PREVIOUS_ID), relation.getTarget());
                    relation.getTarget().addPropertyValue(PropertyDescriptors.PREVIOUS_ID, null);
                }
            }

            public void relationsRemoved(INode node, Collection<INodeRelation> relations) {
            }
        });
        for (Map.Entry<Long, Link> entry : this.extractor.getLinkTemplates().entrySet()) {
            INode template = this.elementTransformer.transformLink(entry.getValue(), TemplateTypes.TEMPLATE_LINK);
            INode n = Transformer.checkAlreadyExistingTemplate((RepositoryDecorator)linkTemplateRepository, template);
            if (n != null) {
                this.elementTransformer.addPreviousLinkTemplate(entry.getValue().getId(), n);
                continue;
            }
            template.addPropertyValue(PropertyDescriptors.PREVIOUS_ID, (Object)entry.getValue().getId());
            INodeRelation relation = NodeRelationFactories.INSTANCE.create(TemplateTypes.TEMPLATE_LINK, SequenceUtils.next(), (INode)linkTemplateRepository, template);
            linkTemplateRepository.addRelation(relation);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void transformMap3Tree(INode root) {
        for (Map.Entry<Long, List<Long>> entry : this.extractor.getCtnRelations().entrySet()) {
            Container sourceMap3 = this.extractor.getContainer(entry.getKey());
            for (Long targetMap3Id : entry.getValue()) {
                INode target;
                INode source;
                block10: {
                    block9: {
                        Container targetMap3 = this.extractor.getContainer(targetMap3Id);
                        if (sourceMap3 != null) {
                            INode iNode = source = this.newNodes.get(sourceMap3.getId()) == null ? this.elementTransformer.transformContainer(sourceMap3) : this.newNodes.get(sourceMap3.getId());
                            if (source == null) {
                                this.eventManager.async((StudioEvent)LogEvent.trace(Transformer.class, (String)("Unhandled source element type: " + sourceMap3.getType() + " | id: " + sourceMap3.getId()), (Object[])new Object[0]));
                                continue;
                            }
                            this.newNodes.put(sourceMap3.getId(), source);
                        } else {
                            source = root;
                        }
                        if (targetMap3 == null) break block9;
                        target = this.newNodes.get(targetMap3.getId());
                        if (target != null) break block10;
                        target = this.elementTransformer.transformContainer(targetMap3);
                        if (target == null) {
                            this.eventManager.async((StudioEvent)LogEvent.trace(Transformer.class, (String)("Unhandled target element type: " + targetMap3.getType() + " | id: " + targetMap3.getId()), (Object[])new Object[0]));
                            continue;
                        }
                        this.newNodes.put(targetMap3.getId(), target);
                        if (target.getProperty(PropertyDescriptors.ZOOM) == PropertyDescriptors.ZOOM.defaulValue) break block10;
                        source.addPropertyValue(PropertyDescriptors.ZOOM, (Object)((Double)target.getProperty(PropertyDescriptors.ZOOM)));
                        break block10;
                    }
                    this.eventManager.async((StudioEvent)LogEvent.trace(Transformer.class, (String)("Unknown target. ID: " + entry.getValue()), (Object[])new Object[0]));
                    continue;
                }
                ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>(3);
                properties.add(new PropertyValue(PropertyDescriptors.POSITION, (Object)((Pos)target.getProperty(PropertyDescriptors.POSITION))));
                properties.add(new PropertyValue(PropertyDescriptors.DIMENSION, (Object)((Pos)target.getProperty(PropertyDescriptors.DIMENSION))));
                properties.add(new PropertyValue(ElementPropertyDescriptors.LATLNG, (Object)((LatLng)target.getProperty(ElementPropertyDescriptors.LATLNG))));
                INodeRelation relation = NodeRelationFactories.INSTANCE.create(ElementTypes.RELATION_HIERARCHY, SequenceUtils.next(), source, target, properties);
                source.addRelation(relation);
            }
        }
        this.progressMonitor.worked(1);
        this.progressMonitor.setTaskName("Import links");
        Collection<Link> allLinks = this.extractor.getLinks().values();
        for (Link link : allLinks) {
            INode source = this.newNodes.get(link.getSourceId());
            INode target = this.newNodes.get(link.getTargetId());
            if (source == null || target == null) {
                String error = source == null ? "source: " + link.getSourceId() : "target: " + link.getTargetId();
                this.eventManager.async((StudioEvent)LogEvent.trace(Transformer.class, (String)("Cannot find link " + error), (Object[])new Object[0]));
                continue;
            }
            INode newLink = this.elementTransformer.transformLink(link, ElementTypes.ELEMENT_LINK);
            INodeRelation parentRelation = INodeUtils.findRelationForTarget((INode)root, null, (Long)source.getId(), (PropertyValue[])new PropertyValue[0]);
            if (parentRelation == null) {
                this.eventManager.async((StudioEvent)LogEvent.trace(Transformer.class, (String)("Relation not found for target but it should have been found!!! ID: " + source.getId()), (Object[])new Object[0]));
                continue;
            }
            INode parent = INodeUtils.findRelationForTarget((INode)root, null, (Long)source.getId(), (PropertyValue[])new PropertyValue[0]).getSource();
            INodeRelation relation = NodeRelationFactories.INSTANCE.create(StudioTypes.RELATION_LINK, SequenceUtils.next(), parent, newLink);
            parent.addRelation(relation);
        }
        this.progressMonitor.worked(1);
    }
}

