/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.importexport;

import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.SeparatorAction;
import com.centreon.studio.client.model.ui.actions.common.StudioAction;
import com.centreon.studio.client.model.ui.actionsets.ActionSetContributor;
import com.centreon.studio.client.model.ui.actionsets.ActionSetDescriptor;
import com.centreon.studio.map.client.gates.model.GateRepositoryDecorator;
import com.centreon.studio.map.client.gates.ui.GateActionSetDescriptor;
import com.centreon.studio.map.client.importexport.GateExportAction;
import com.centreon.studio.map.client.importexport.GateImportAction;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class ImportExportAddon
implements ActionSetContributor {
    @Inject
    public ImportExportAddon() {
        ActionSetDescriptor.contribute(GateActionSetDescriptor.class, (ActionSetContributor)this);
    }

    public void contribute(List<StudioAction> actions, IEclipseContext context) {
        IRepository input = (IRepository)ContextInjectionFactory.make(GateRepositoryDecorator.class, (IEclipseContext)context);
        BrokerEventManager eventManager = (BrokerEventManager)ContextInjectionFactory.make(BrokerEventManager.class, (IEclipseContext)context);
        actions.add(actions.size() - 2, (StudioAction)SeparatorAction.INSTANCE);
        actions.add(actions.size() - 2, (StudioAction)new GateExportAction(input, eventManager, context));
        actions.add(actions.size() - 2, (StudioAction)new GateImportAction(input, eventManager, context));
        actions.add(actions.size() - 2, (StudioAction)SeparatorAction.INSTANCE);
    }

    @PostConstruct
    public void postConstruct(BrokerEventManager eventManager) {
        eventManager.async((StudioEvent)LogEvent.trace(this.getClass(), (String)"Import Export addon loaded", (Object[])new Object[0]));
    }

    @PreDestroy
    public void preDestroy(BrokerEventManager eventManager) {
        eventManager.async((StudioEvent)LogEvent.trace(this.getClass(), (String)"Import Export addon destroyed", (Object[])new Object[0]));
    }
}

