/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.templates;

import com.centreon.studio.client.acl.ACLUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.auth.AuthenticationEventHandler;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.gef.palette.CustomPaletteRoot;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.map.client.elements.model.ui.parts.CustomPaletteViewer;
import com.centreon.studio.map.client.elements.model.ui.parts.ElementPalettePart;
import com.centreon.studio.map.client.elements.templates.TemplateRepository;
import com.centreon.studio.map.client.elements.templates.TemplateSyncEventHandler;
import com.centreon.studio.map.client.elements.templates.TemplateTypes;
import com.centreon.studio.map.client.elements.templates.TemplateWebService;
import com.centreon.studio.map.client.elements.templates.links.LinkTemplatePaletteRoot;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class TemplateAddon
extends TemplateSyncEventHandler {
    private final AuthenticationEventHandler authenticationEventHandler;

    @Inject
    public TemplateAddon(ACLUtils utils, final TemplateWebService service, final TemplateRepository repository) {
        super(service, repository);
        this.authenticationEventHandler = new AuthenticationEventHandler(){

            protected void loggedIn() {
                List relations = service.getElementsByTypes(Arrays.asList(TemplateTypes.TEMPLATE_LINK));
                repository.addRelations(relations);
            }

            protected void loggedOut() {
                repository.setSelection((Object)this, null);
                repository.removeRelations(repository.getRelations(new TypeDescriptor[0]));
            }
        };
        utils.register(TemplateTypes.TEMPLATE_LINK);
    }

    @PostConstruct
    public void postConstruct(BrokerEventManager eventManager, LinkTemplatePaletteRoot linkTemplatePaletteRoot) {
        ElementPalettePart.register((CustomPaletteViewer.PaletteType)CustomPaletteViewer.PaletteType.TEMPLATE, (CustomPaletteRoot)linkTemplatePaletteRoot);
        eventManager.subscribe("studio/sync", true, (StudioEventHandler)this);
        eventManager.subscribe("studio/authentication", true, (StudioEventHandler)this.authenticationEventHandler);
        eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Template addon loaded", (Object[])new Object[0]));
    }

    @PreDestroy
    public void preDestroy(BrokerEventManager eventManager, LinkTemplatePaletteRoot linkTemplatePaletteRoot) {
        ElementPalettePart.unregister((CustomPaletteViewer.PaletteType)CustomPaletteViewer.PaletteType.TEMPLATE);
        eventManager.unsubscribe((StudioEventHandler)this);
        eventManager.unsubscribe((StudioEventHandler)this.authenticationEventHandler);
        eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Template addon destroyed", (Object[])new Object[0]));
    }
}

