/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.templates;

import com.centreon.studio.client.events.sync.SyncEvent;
import com.centreon.studio.client.events.sync.SyncEventHandler;
import com.centreon.studio.client.model.IWebService;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.map.client.elements.templates.TemplateRepository;
import com.centreon.studio.map.client.elements.templates.TemplateTypes;
import com.centreon.studio.map.client.elements.templates.TemplateWebService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class TemplateSyncEventHandler
extends SyncEventHandler {
    private final TemplateRepository repository;
    private final IWebService service;

    public TemplateSyncEventHandler(TemplateWebService service, TemplateRepository templateRepository) {
        super(Arrays.asList(TemplateTypes.TEMPLATE_LINK.getId()));
        this.repository = templateRepository;
        this.service = service;
    }

    public void handleEvent(SyncEvent event) {
        block6: {
            ArrayList<Long> ids;
            block7: {
                List relations;
                block5: {
                    Collection datas = event.getData();
                    ids = new ArrayList<Long>(datas.size());
                    for (SyncEvent.SyncData data : datas) {
                        if (data.getId() == -1L) {
                            this.applyFullDelta(event);
                            return;
                        }
                        ids.add(data.getId());
                    }
                    if (event.getAction() != SyncEvent.SyncAction.CREATE) break block5;
                    relations = this.service.getElementsByIds(ids);
                    for (INodeRelation relation : relations) {
                        relation.getSource().addRelation(relation);
                    }
                    break block6;
                }
                if (event.getAction() != SyncEvent.SyncAction.UPDATE) break block7;
                relations = this.service.getElementsByIds(ids);
                for (INodeRelation relation : relations) {
                    INode existing = INodeUtils.findNode((INode)this.repository, (TypeDescriptor)relation.getTarget().getType(), (Long)relation.getTarget().getId(), (PropertyValue[])new PropertyValue[0]);
                    if (existing == null) continue;
                    INodeUtils.updateProperties((IObject)existing, (Collection)relation.getTarget().getPropertyValues(), (boolean)true, (boolean)true, (String[])new String[0]);
                }
                break block6;
            }
            if (event.getAction() != SyncEvent.SyncAction.REMOVE) break block6;
            for (Long id : ids) {
                INodeRelation relation = INodeUtils.findRelationForTarget((INode)this.repository, (TypeDescriptor)TemplateTypes.TEMPLATE_LINK, (Long)id, (PropertyValue[])new PropertyValue[0]);
                if (relation == null) continue;
                relation.getSource().removeRelation(relation);
            }
        }
    }

    private void applyFullDelta(SyncEvent event) {
        List remoteRelations = this.service.getElementsByTypes(Arrays.asList(TemplateTypes.TEMPLATE_LINK));
        if (event.getAction() == SyncEvent.SyncAction.CREATE || event.getAction() == SyncEvent.SyncAction.UPDATE) {
            ArrayList<INodeRelation> relations = new ArrayList<INodeRelation>(remoteRelations.size());
            for (INodeRelation relation : remoteRelations) {
                INode toUpdate = INodeUtils.findNode((INode)this.repository, (TypeDescriptor)TemplateTypes.TEMPLATE_LINK, (Long)relation.getTarget().getId(), (PropertyValue[])new PropertyValue[0]);
                if (toUpdate != null) {
                    INodeUtils.updateProperties((IObject)toUpdate, (Collection)relation.getTarget().getPropertyValues(), (boolean)false, (boolean)true, (String[])new String[0]);
                    continue;
                }
                relations.add(relation);
            }
            this.repository.addRelations(relations);
        } else if (event.getAction() == SyncEvent.SyncAction.REMOVE) {
            List relations = this.repository.getRelations(new TypeDescriptor[]{TemplateTypes.TEMPLATE_LINK});
            this.repository.removeRelations(relations);
        }
    }
}

