/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.templates;

import com.centreon.studio.client.model.StudioTypes;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.edit.WizardCreateNodeRelationAction;
import com.centreon.studio.map.client.elements.templates.TemplateTypes;
import com.centreon.studio.map.client.elements.templates.messages.TemplateMessages;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.jface.resource.ImageDescriptor;

public class TemplateToolEntry
extends ToolEntry {
    private static final String TEMPLATE_LINK_SMALL_IMAGE_PATH = "platform:/plugin/com.centreon.studio.map.client.elements.templates/img/link-tpl-small.png";
    private static final String TEMPLATE_LINK_IMAGE_PATH = "platform:/plugin/com.centreon.studio.map.client.elements.templates/img/link-tpl.png";
    private final IRepository repository;
    private final IEclipseContext context;

    public TemplateToolEntry(IRepository repository, IEclipseContext context) {
        super(TemplateMessages.labelLinkTemplate, TemplateMessages.labelLinkTemplate, null, null, null);
        this.repository = repository;
        this.context = context;
    }

    public Tool createTool() {
        return new AbstractTool(){

            public void activate() {
                super.activate();
                new WizardCreateNodeRelationAction(TemplateToolEntry.this.repository, TemplateToolEntry.this.context, TemplateTypes.TEMPLATE_LINK, StudioTypes.RELATION_DELEGATE, true).run();
                this.handleFinished();
            }

            protected String getCommandName() {
                return "linkTemplateCreationCommand";
            }
        };
    }

    public ImageDescriptor getLargeIcon() {
        try {
            return ImageDescriptor.createFromURL((URL)new URL(TEMPLATE_LINK_IMAGE_PATH));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public ImageDescriptor getSmallIcon() {
        try {
            return ImageDescriptor.createFromURL((URL)new URL(TEMPLATE_LINK_SMALL_IMAGE_PATH));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.repository == null ? 0 : this.repository.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TemplateToolEntry other = (TemplateToolEntry)((Object)obj);
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        return !(this.repository == null ? other.repository != null : !this.repository.equals((Object)other.repository));
    }
}

