/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.templates;

import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.ui.dialogs.CustomWizard;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardDialog;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardPage;
import com.centreon.studio.client.model.ui.dialogs.IWizardFactory;
import com.centreon.studio.map.client.elements.model.ui.wizards.LinkPropertiesWizardPage;
import com.centreon.studio.map.client.elements.templates.TemplateTypes;
import com.centreon.studio.map.client.elements.templates.messages.TemplateMessages;
import com.centreon.studio.map.client.resources.model.repository.decorators.ResourceRepositoryDecorator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public enum TemplateWizardFactory implements IWizardFactory
{
    INSTANCE;

    private static final Set<TypeDescriptor> SUPPORTED_TYPES;

    static {
        SUPPORTED_TYPES = new HashSet<TypeDescriptor>(2);
        SUPPORTED_TYPES.add(TemplateTypes.TEMPLATE_LINK);
    }

    public CustomWizardDialog createDialog(INodeRelation input, IEclipseContext context) {
        if (input == null) {
            return null;
        }
        ResourceRepositoryDecorator resourceRepository = (ResourceRepositoryDecorator)ContextInjectionFactory.make(ResourceRepositoryDecorator.class, (IEclipseContext)context);
        CustomWizard wizard = new CustomWizard(TemplateMessages.labelLinkTemplate);
        wizard.registerPage((CustomWizardPage)new LinkPropertiesWizardPage(resourceRepository, true));
        CustomWizardDialog dialog = new CustomWizardDialog(wizard);
        dialog.setInput(Arrays.asList(input));
        return dialog;
    }

    public Collection<TypeDescriptor> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }
}

