/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.templates.links;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.gef.palette.ContextCreationToolEntry;
import com.centreon.studio.client.gef.palette.CustomPaletteRoot;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeRelationListener;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actionsets.ActionSetDescriptor;
import com.centreon.studio.client.model.ui.contributionmanagers.CustomMenuManager;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import com.centreon.studio.map.client.elements.templates.TemplateRepositoryDecorator;
import com.centreon.studio.map.client.elements.templates.TemplateToolEntry;
import com.centreon.studio.map.client.elements.templates.TemplateTypes;
import com.centreon.studio.map.client.elements.templates.links.LinkTemplateActionSetDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.ConnectionCreationTool;
import org.eclipse.swt.widgets.Control;

@Creatable
@Singleton
public class LinkTemplatePaletteRoot
extends CustomPaletteRoot
implements INodeRelationListener {
    private final PaletteGroup group;
    private final IEclipseContext context;
    private final LinkTemplateActionSetDescriptor actionSetDescriptor;

    private static CreationFactory createFactory(final INodeRelation relation) {
        return new CreationFactory(){

            public Object getNewObject() {
                return relation;
            }

            public Object getObjectType() {
                return null;
            }
        };
    }

    @Inject
    public LinkTemplatePaletteRoot(IEclipseContext context, TemplateRepositoryDecorator repository, LinkTemplateActionSetDescriptor actionSetDescriptor) {
        super((IRepository)repository);
        this.context = context;
        this.repository.registerRelationsListener((INodeRelationListener)this);
        this.actionSetDescriptor = actionSetDescriptor;
        this.group = new PaletteGroup("Link templates");
        this.add((PaletteEntry)this.group);
        this.setUserModificationPermission(15);
        SWTUtils.getDisplay().syncExec(() -> this.refreshEntries());
    }

    public CustomMenuManager getMenuManager(Control control) {
        return new CustomMenuManager((ActionSetDescriptor)this.actionSetDescriptor, control);
    }

    @PreDestroy
    public void preDestroy() {
        this.repository.unregisterRelationsListener((INodeRelationListener)this);
    }

    public void relationsAdded(INode node, Collection<INodeRelation> relations) {
        SWTUtils.getDisplay().syncExec(() -> this.refreshEntries());
    }

    public void relationsRemoved(INode node, Collection<INodeRelation> relations) {
        SWTUtils.getDisplay().syncExec(() -> this.refreshEntries());
    }

    private ToolEntry createEntry(String label, String desc, CreationFactory factory, INodeRelation relation) {
        return new ContextCreationToolEntry(label, desc, factory, this.context, ConnectionCreationTool.class, ElementTypes.ELEMENT_LINK.getSmallImage(), Boolean.FALSE, relation);
    }

    private void refreshEntries() {
        ArrayList copiedChildren = new ArrayList(this.group.getChildren());
        for (PaletteEntry child : copiedChildren) {
            this.group.remove(child);
        }
        this.group.add((PaletteEntry)new TemplateToolEntry(this.repository, this.context));
        for (INodeRelation relation : this.repository.getRelations(new TypeDescriptor[]{TemplateTypes.TEMPLATE_LINK})) {
            String entryLabel = relation.getTarget().getLabel();
            this.group.add((PaletteEntry)this.createEntry(entryLabel, entryLabel, LinkTemplatePaletteRoot.createFactory(relation), relation));
        }
    }
}

