/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.templates.links;

import com.centreon.studio.client.commons.jface.StudioRegistries;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.StudioColor;
import com.centreon.studio.client.model.StudioFont;
import com.centreon.studio.client.model.decoration.repository.RepositoryDecorator;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.AObject;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyFormatter;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.repository.IRepositoryListener;
import com.centreon.studio.client.model.ui.controls.impl.NodeCombo;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ui.wizards.LinkPropertiesWizardPage;
import com.centreon.studio.map.client.elements.templates.TemplateTypes;
import com.centreon.studio.map.client.elements.templates.messages.TemplateMessages;
import com.centreon.studio.map.client.resources.model.repository.decorators.ResourceRepositoryDecorator;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class TemplateLinkPropertiesWizardPage
extends LinkPropertiesWizardPage
implements IRepositoryListener {
    private final RepositoryDecorator templateRepository;

    private static <T> void displayTemplateValue(Composite composite, Collection<Control> elementsToDispose, IRepository repository, PropertyDescriptor<T> property, Control control) {
        if (repository.getSelection() != null) {
            Label spanner = SWTUtils.createSpanner((Composite)composite, (int)1, (int)0);
            if (control != null) {
                spanner.moveBelow(control);
            }
            elementsToDispose.add((Control)spanner);
            PropertyFormatter formatter = PropertyFormatter.getPropetyFormatter((Class)property.clazz);
            Object value = repository.getSelection().getTarget().getProperty(property);
            String text = String.valueOf(TemplateMessages.templateValue) + " " + formatter.toString(value);
            StudioColor studioColor = StudioColor.fromHexadecimal((String)formatter.toColor(value));
            Color color = StudioRegistries.colorRegistry().getSWTColorFrom(studioColor);
            Label label = SWTUtils.createLabel((Composite)composite, (String)text);
            label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            label.setFont(StudioRegistries.fontRegistry().getSWTFontFrom(StudioFont.SMALL));
            label.setBackground(color);
            label.moveBelow((Control)spanner);
            elementsToDispose.add((Control)label);
        }
    }

    protected TemplateLinkPropertiesWizardPage(RepositoryDecorator templateRepository, ResourceRepositoryDecorator repository) {
        super(TemplateLinkPropertiesWizardPage.class.getSimpleName(), repository, false);
        this.templateRepository = templateRepository;
        this.templateRepository.registerSelectionListener((IRepositoryListener)this);
        this.setDescription("Define the template link properties");
    }

    public void dispose() {
        super.dispose();
        this.templateRepository.unregisterSelectionListener((IRepositoryListener)this);
    }

    public Point getPageSize() {
        return new Point(350, 700);
    }

    public void propertiesChanged(IObject object, Collection<PropertyValue> propertyValues) {
        for (PropertyValue pv : propertyValues) {
            if (!ElementPropertyDescriptors.TEMPLATE_ID.equals((Object)pv.getProperty())) continue;
            this.createControls(this.getComposite());
            this.resizeWizard();
            return;
        }
        super.propertiesChanged(object, propertyValues);
    }

    public void selectionChanged(Object source, IRepository repository) {
        Long templateId = repository.getSelection() == null ? null : repository.getSelection().getTarget().getId();
        this.getInput().getTarget().addPropertyValue(ElementPropertyDescriptors.TEMPLATE_ID, (Object)templateId);
    }

    protected void createControlsCommon(Composite composite) {
        this.elementsToDispose.add(SWTUtils.createLabel((Composite)composite, (String)TemplateMessages.labelTemplate));
        Composite templateComposite = SWTUtils.createComposite((Composite)composite, (int)2, (boolean)false, (int)0, (int)0, (GridData)new GridData(4, 0x1000000, false, false));
        new NodeCombo(templateComposite, (INode)this.templateRepository, new TypeDescriptor[]{TemplateTypes.TEMPLATE_LINK});
        this.elementsToDispose.add(templateComposite);
        super.createControlsCommon(composite);
        TemplateLinkPropertiesWizardPage.displayTemplateValue(composite, this.elementsToDispose, (IRepository)this.templateRepository, ElementPropertyDescriptors.LINK_TYPE, (Control)this.typeCombo);
        TemplateLinkPropertiesWizardPage.displayTemplateValue(composite, this.elementsToDispose, (IRepository)this.templateRepository, AObject.LABEL, this.labelTextField.getControl());
        TemplateLinkPropertiesWizardPage.displayTemplateValue(composite, this.elementsToDispose, (IRepository)this.templateRepository, PropertyDescriptors.DISPLAY_LABEL, this.displayLabelCheckField.getControl());
        TemplateLinkPropertiesWizardPage.displayTemplateValue(composite, this.elementsToDispose, (IRepository)this.templateRepository, PropertyDescriptors.FONT, (Control)this.fontButton);
        TemplateLinkPropertiesWizardPage.displayTemplateValue(composite, this.elementsToDispose, (IRepository)this.templateRepository, PropertyDescriptors.FONT_COLOR, (Control)this.fontColorSelectorButton);
        TemplateLinkPropertiesWizardPage.displayTemplateValue(composite, this.elementsToDispose, (IRepository)this.templateRepository, PropertyDescriptors.THICKNESS, (Control)this.thicknessSpinner);
    }

    protected void createControlsMetric(Composite composite) {
        super.createControlsMetric(composite);
        TemplateLinkPropertiesWizardPage.displayTemplateValue(composite, this.elementsToDispose, (IRepository)this.templateRepository, ElementPropertyDescriptors.LINK_FILTER, (Control)this.serviceCombo);
        TemplateLinkPropertiesWizardPage.displayTemplateValue(composite, this.elementsToDispose, (IRepository)this.templateRepository, ElementPropertyDescriptors.METRIC_SOURCE, (Control)this.metric1Combo);
        TemplateLinkPropertiesWizardPage.displayTemplateValue(composite, this.elementsToDispose, (IRepository)this.templateRepository, ElementPropertyDescriptors.LINK_IS_DOUBLE, this.doubleMetricField.getControl());
        TemplateLinkPropertiesWizardPage.displayTemplateValue(composite, this.elementsToDispose, (IRepository)this.templateRepository, ElementPropertyDescriptors.METRIC_TARGET, (Control)this.metric2Combo);
    }

    protected void createControlsSimple(Composite composite) {
        super.createControlsSimple(composite);
        TemplateLinkPropertiesWizardPage.displayTemplateValue(composite, this.elementsToDispose, (IRepository)this.templateRepository, PropertyDescriptors.LINE, (Control)this.lineCombo);
        TemplateLinkPropertiesWizardPage.displayTemplateValue(composite, this.elementsToDispose, (IRepository)this.templateRepository, PropertyDescriptors.COLOR, (Control)this.lineColorSelectorButton);
    }

    protected void createControlsStatus(Composite composite) {
        super.createControlsStatus(composite);
        TemplateLinkPropertiesWizardPage.displayTemplateValue(composite, this.elementsToDispose, (IRepository)this.templateRepository, PropertyDescriptors.LINE, (Control)this.lineCombo);
    }

    protected boolean performFinish() {
        Long templateId = (Long)this.getInput().getTarget().getProperty(ElementPropertyDescriptors.TEMPLATE_ID);
        INodeRelation templateRelation = INodeUtils.findRelationForTarget((INode)this.templateRepository, null, (Long)templateId, (PropertyValue[])new PropertyValue[0]);
        if (templateRelation != null) {
            INode link = this.getInput().getTarget();
            ArrayList<PropertyValue> removedValues = new ArrayList<PropertyValue>(12);
            for (PropertyValue pv : templateRelation.getPropertyValues()) {
                Object linkValue = link.getProperty(pv.getProperty());
                if (linkValue == null || !linkValue.equals(pv.getValue())) continue;
                removedValues.add(new PropertyValue(pv.getProperty(), null));
            }
            link.addPropertyValues(removedValues);
        }
        return super.performFinish();
    }

    protected void setInput(INodeRelation input) {
        super.setInput(input);
        Long templateId = (Long)this.getInput().getTarget().getProperty(ElementPropertyDescriptors.TEMPLATE_ID);
        ArrayList<INodeRelation> selection = new ArrayList<INodeRelation>();
        INodeRelation templateRelation = INodeUtils.findRelationForTarget((INode)this.templateRepository, null, (Long)templateId, (PropertyValue[])new PropertyValue[0]);
        if (templateRelation != null) {
            selection.add(templateRelation);
            INode copiedTemplate = INodeUtils.copy((INode)templateRelation.getTarget(), (boolean)true, (boolean)true, (IRepository)this.templateRepository, (PropertyValue[])new PropertyValue[0]);
            INodeUtils.performDelta((INode)copiedTemplate, (INode)this.getInput().getTarget(), (boolean)true, (boolean)true, (boolean)false, (boolean)true);
            INodeUtils.performDelta((INode)this.getInput().getTarget(), (INode)copiedTemplate, (boolean)true, (boolean)true, (boolean)false, (boolean)true);
        }
        this.templateRepository.setSelection((Object)this, selection);
    }
}

