/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.geo.gef;

import com.centreon.studio.client.commons.threads.GraphicalThreadDelayer;
import com.centreon.studio.client.gef.CustomMarqueeDragTracker;
import com.centreon.studio.client.gef.CustomZoomManager;
import com.centreon.studio.client.gef.editparts.CustomScalableFreeformRootEditPart;
import com.centreon.studio.client.model.LatLng;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.ui.actions.zoom.IZoomable;
import com.centreon.studio.map.client.elements.geo.gef.GeoDefaultInputGraphicalEditPart;
import com.centreon.studio.map.client.elements.geo.gef.GeoPanningTracker;
import com.centreon.studio.map.client.elements.geo.gef.TilesBackgroundFigure;
import com.centreon.studio.map.client.elements.geo.model.GeoPropertyDescriptors;
import com.centreon.studio.map.client.elements.geo.model.ui.actions.ResetPositionAction;
import com.centreon.studio.map.client.elements.geo.providers.MapBoxProvider;
import com.centreon.studio.map.client.elements.geo.tiles.StyleDescription;
import com.centreon.studio.map.client.elements.geo.tiles.TileDescription;
import com.centreon.studio.map.client.elements.geo.tiles.TileFigure;
import com.centreon.studio.map.client.elements.geo.tiles.TilesUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GeoInputGraphicalEditPart
extends GeoDefaultInputGraphicalEditPart
implements Listener,
Runnable,
ControlListener {
    private static final int WN = 3;
    private static final int HN = 2;
    private final List<TileFigure> figures = new ArrayList<TileFigure>(35);
    private MapBoxProvider provider;
    private GraphicalThreadDelayer delayerThread;
    private CustomZoomManager zoomManager;
    private DragTracker dragTracker;
    private boolean activated;
    private boolean zooming;
    private boolean init;

    public GeoInputGraphicalEditPart(INodeRelation relation, TypeDescriptor ... types) {
        super(relation, types);
    }

    public void activate() {
        super.activate();
        if (!this.activated) {
            this.activated = true;
            this.getRoot().getViewer().getControl().addControlListener((ControlListener)this);
            this.getRoot().getViewer().getControl().addListener(37, (Listener)this);
            IEclipseContext context = (IEclipseContext)this.getViewer().getProperty(IEclipseContext.class.getSimpleName());
            this.provider = (MapBoxProvider)ContextInjectionFactory.make(MapBoxProvider.class, (IEclipseContext)context);
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.refreshVisuals();
    }

    public void deactivate() {
        super.deactivate();
        if (this.activated) {
            this.getRoot().getViewer().getControl().removeControlListener((ControlListener)this);
            this.activated = false;
        }
    }

    public DragTracker getDragTracker(Request req) {
        if (((Boolean)this.getModel().getTarget().getProperty(PropertyDescriptors.LOCKED)).booleanValue()) {
            return new CustomMarqueeDragTracker();
        }
        if (this.dragTracker == null) {
            this.dragTracker = new GeoPanningTracker(this);
        }
        return this.dragTracker;
    }

    public void handleEvent(Event event) {
        event.doit = event.type != 37 || (event.stateMask & SWT.MOD1) == SWT.MOD1;
    }

    @Override
    public void propertiesChanged(IObject object, Collection<PropertyValue> propertyValues) {
        super.propertiesChanged(object, propertyValues);
        for (PropertyValue pv : propertyValues) {
            if (pv.getProperty() != GeoPropertyDescriptors.MAPBOX_STYLE && pv.getProperty() != PropertyDescriptors.CURRENT_ZOOM && pv.getProperty() != GeoPropertyDescriptors.CURRENT_LATLNG) continue;
            this.refreshVisuals();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<TileFigure> list = this.figures;
        synchronized (list) {
            for (TileFigure child : this.figures) {
                try {
                    if (child.getParent() == null) continue;
                    child.getParent().remove((IFigure)child);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            this.figures.clear();
        }
        if (this.getViewer() == null || this.getViewer().getRootEditPart() == null) {
            return;
        }
        Viewport viewport = (Viewport)((CustomScalableFreeformRootEditPart)this.getViewer().getRootEditPart()).getFigure();
        Dimension viewPortSize = viewport.getSize();
        viewport.setViewLocation(-viewPortSize.width / 2, -viewPortSize.height / 2);
        LatLng latlng = (LatLng)this.getModel().getProperty(GeoPropertyDescriptors.CURRENT_LATLNG);
        StyleDescription style = (StyleDescription)this.getModel().getTarget().getProperty(GeoPropertyDescriptors.MAPBOX_STYLE);
        int zoom = ((Double)this.getModel().getTarget().getProperty(PropertyDescriptors.CURRENT_ZOOM)).intValue();
        final Pos pos = MapBoxProvider.toPoint(latlng, zoom);
        TileDescription centerTile = TilesUtils.posToTileDescription(pos, zoom, style);
        Collection<TileDescription> tilesAroundCenter = TilesUtils.tilesAround(centerTile, 3, 2);
        for (final TileDescription tile : tilesAroundCenter) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Image image = GeoInputGraphicalEditPart.this.provider.getTile(tile);
                    TileFigure tileFigure = new TileFigure(image, tile.pos.minus(pos));
                    List list = GeoInputGraphicalEditPart.this.figures;
                    synchronized (list) {
                        GeoInputGraphicalEditPart.this.figures.add(tileFigure);
                    }
                    Display.getDefault().asyncExec(() -> GeoInputGraphicalEditPart.this.figure.add((IFigure)tileFigure));
                }
            }.start();
        }
        Dimension size = new Dimension(3584, 2560);
        this.figure.setSize(size);
        TileDescription cornerTile = new TileDescription(centerTile.z, centerTile.x - 3, centerTile.y - 2, style);
        Pos cornerPos = cornerTile.pos.minus(pos);
        Point location = new Point(cornerPos.x.intValue(), cornerPos.y.intValue());
        this.figure.setLocation(location);
        if (!this.init) {
            this.init = true;
            this.getModel().getRepository().setSelection((Object)this, Arrays.asList(this.getModel()));
            new ResetPositionAction(this.getModel().getRepository()).run();
        }
        this.refreshChildren();
        this.refreshConnections();
        this.zooming = false;
    }

    protected IFigure createFigure() {
        RootEditPart root = this.getRoot();
        if (root instanceof CustomScalableFreeformRootEditPart) {
            CustomScalableFreeformRootEditPart scalableFreeformRootEditPart = (CustomScalableFreeformRootEditPart)root;
            this.zoomManager = scalableFreeformRootEditPart.getZoomManager();
            this.zoomManager.setZoomDelegate((IZoomable)new GeoZoomDelegate());
        }
        FigureCanvas canvas = (FigureCanvas)this.getViewer().getControl();
        canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        TilesBackgroundFigure imageFigure = new TilesBackgroundFigure();
        imageFigure.setLayoutManager((LayoutManager)new FreeformLayout());
        return imageFigure;
    }

    protected List<INodeRelation> getModelChildren() {
        Rectangle bounds = this.figure.getBounds();
        if (bounds.isEmpty()) {
            return Collections.emptyList();
        }
        List modelChildren = super.getModelChildren();
        Iterator it = modelChildren.iterator();
        while (it.hasNext()) {
            INodeRelation relation = (INodeRelation)it.next();
            Pos pos = (Pos)relation.getProperty(PropertyDescriptors.CURRENT_POSITION);
            Pos dim = ((Pos)relation.getProperty(PropertyDescriptors.CURRENT_DIMENSION)).div(2.0);
            if (!(pos.x - dim.x < (double)bounds.x || pos.x + dim.x > (double)(bounds.x + bounds.width) || pos.y - dim.y < (double)bounds.y) && !(pos.y + dim.y > (double)(bounds.y + bounds.height))) continue;
            it.remove();
        }
        return modelChildren;
    }

    protected void refreshVisuals() {
        if (this.delayerThread == null || !this.delayerThread.isAlive()) {
            this.delayerThread = new GraphicalThreadDelayer((Runnable)this, true, 100);
            this.delayerThread.start();
        } else {
            this.delayerThread.requireRedelay();
        }
    }

    private class GeoZoomDelegate
    implements IZoomable {
        private GeoZoomDelegate() {
        }

        public double getDefaultZoom() {
            return MapBoxProvider.getZoomLevels()[4];
        }

        public double getMaxZoom() {
            return MapBoxProvider.getMaxZoom();
        }

        public double getMinZoom() {
            return MapBoxProvider.getMinZoom();
        }

        public double getZoom() {
            return (Double)GeoInputGraphicalEditPart.this.getModel().getTarget().getProperty(PropertyDescriptors.CURRENT_ZOOM);
        }

        public double[] getZoomLevels() {
            return MapBoxProvider.getZoomLevels();
        }

        public void setZoom(int x, int y, double zoom) {
            if (zoom <= MapBoxProvider.getMaxZoom() && zoom >= MapBoxProvider.getMinZoom()) {
                if (!GeoInputGraphicalEditPart.this.zooming) {
                    GeoInputGraphicalEditPart.this.zooming = true;
                }
                GeoInputGraphicalEditPart.this.getModel().addPropertyValue(GeoPropertyDescriptors.CURRENT_LATLNG, (Object)this.getLatLng(x, y));
                GeoInputGraphicalEditPart.this.getModel().getTarget().addPropertyValue(PropertyDescriptors.CURRENT_ZOOM, (Object)zoom);
            }
        }

        public void zoomIn(int x, int y) {
            Double zoom = (Double)GeoInputGraphicalEditPart.this.getModel().getTarget().getProperty(PropertyDescriptors.CURRENT_ZOOM);
            this.setZoom(x, y, zoom + 1.0);
        }

        public void zoomOut(int x, int y) {
            Double zoom = (Double)GeoInputGraphicalEditPart.this.getModel().getTarget().getProperty(PropertyDescriptors.CURRENT_ZOOM);
            this.setZoom(x, y, zoom - 1.0);
        }

        private LatLng getLatLng(double x, double y) {
            LatLng center = (LatLng)GeoInputGraphicalEditPart.this.getModel().getProperty(GeoPropertyDescriptors.CURRENT_LATLNG);
            if (x != -1.0 && y != -1.0) {
                Double zoom = (Double)GeoInputGraphicalEditPart.this.getModel().getTarget().getProperty(PropertyDescriptors.CURRENT_ZOOM);
                Viewport viewport = (Viewport)((CustomScalableFreeformRootEditPart)GeoInputGraphicalEditPart.this.getViewer().getRootEditPart()).getFigure();
                Dimension viewPortSize = viewport.getSize();
                Pos point = Pos.create((double)x, (double)y).minus((double)viewPortSize.width / 2.0, (double)viewPortSize.height / 2.0);
                center = MapBoxProvider.pointToLatLng(point, zoom.intValue(), center);
            }
            return center;
        }
    }
}

